/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.objects.view.DamagedObjectView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.Collections;
import java.util.Map;

@ReadOnlyOperation
public class ScanOperation
extends BHive.Operation<TreeView> {
    private ObjectId treeId;
    private int maxDepth = Integer.MAX_VALUE;
    private Manifest.Key manifest;
    private boolean followReferences = true;

    @Override
    public TreeView call() throws Exception {
        if (this.manifest != null) {
            Manifest mf = this.execute(new ManifestLoadOperation().setManifest(this.manifest));
            RuntimeAssert.assertNotNull(mf, "Given manifest not found");
            this.treeId = mf.getRoot();
        }
        RuntimeAssert.assertNotNull(this.treeId, "No tree to scan");
        TreeView result = this.getObjectManager().scan(this.treeId, this.maxDepth, this.followReferences);
        if (result.getChildren().size() == 1) {
            Map.Entry<String, ElementView> entry = result.getChildren().entrySet().iterator().next();
            if (this.manifest != null && entry.getValue() instanceof DamagedObjectView && entry.getValue().getElementId().equals(this.treeId)) {
                result = new TreeView(result.getElementId(), result.getPath());
                result.addChild(new DamagedObjectView(this.treeId, Tree.EntryType.MANIFEST, Collections.singleton(this.manifest.toString())));
            }
        }
        return result;
    }

    public ScanOperation setManifest(Manifest.Key manifest) {
        this.manifest = manifest;
        return this;
    }

    public ScanOperation setTree(ObjectId treeId) {
        this.treeId = treeId;
        return this;
    }

    public ScanOperation setMaxDepth(int max) {
        this.maxDepth = max;
        return this;
    }

    public ScanOperation setFollowReferences(boolean follow) {
        this.followReferences = follow;
        return this;
    }
}

