/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import com.google.common.base.Splitter;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.InputStream;

@ReadOnlyOperation
public class TreeEntryLoadOperation
extends BHive.Operation<InputStream> {
    private String relPath;
    private ObjectId tree;

    @Override
    public InputStream call() throws Exception {
        RuntimeAssert.assertNotNull(this.relPath, "File to load not set");
        RuntimeAssert.assertNotNull(this.tree, "Tree to load from not set");
        return this.getObjectManager().getStreamForRelativePath(this.tree, Splitter.on('/').splitToList(this.relPath).toArray(new String[0]));
    }

    public TreeEntryLoadOperation setRootTree(ObjectId tree) {
        this.tree = tree;
        return this;
    }

    public TreeEntryLoadOperation setRelativePath(String relPath) {
        this.relPath = relPath;
        return this;
    }
}

