/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.InputStream;

@ReadOnlyOperation
public class TreeLoadOperation
extends BHive.Operation<Tree> {
    private ObjectId treeId;

    @Override
    public Tree call() throws Exception {
        RuntimeAssert.assertNotNull(this.treeId, "Tree to load not set");
        try (InputStream is = this.getObjectManager().db(x -> x.getStream(this.treeId));){
            Tree tree = StorageHelper.fromStream(is, Tree.class);
            return tree;
        }
    }

    public TreeLoadOperation setTree(ObjectId tree) {
        this.treeId = tree;
        return this;
    }
}

