/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ObjectExistsOperation;
import io.bdeploy.bhive.op.ObjectReadOperation;
import io.bdeploy.bhive.op.remote.TransactedRemoteOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class FetchOperation
extends TransactedRemoteOperation<TransferStatistics, FetchOperation> {
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private String hiveName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics callTransacted() throws Exception {
        TransferStatistics stats = new TransferStatistics();
        RuntimeAssert.assertNotNull(this.getRemote(), "Remote not set");
        TreeSet<Manifest.Key> requiredManifests = new TreeSet<Manifest.Key>();
        TreeSet<ObjectId> toFetchRootTrees = new TreeSet<ObjectId>();
        Instant start = Instant.now();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Fetching", -1L);
             RemoteBHive rh = RemoteBHive.forService(this.getRemote(), this.hiveName, this.getActivityReporter());){
            String[] manifestsAsArray = (String[])this.manifests.stream().map(Manifest.Key::toString).toArray(String[]::new);
            SortedMap<Manifest.Key, ObjectId> manifest2Tree = rh.getManifestInventory(manifestsAsArray);
            if (this.manifests.isEmpty()) {
                this.manifests.addAll(manifest2Tree.keySet());
            }
            for (Manifest.Key key : this.manifests) {
                if (!manifest2Tree.containsKey(key)) {
                    throw new IllegalArgumentException("Manifest not found: " + key);
                }
                if (this.getManifestDatabase().hasManifest(key)) continue;
                requiredManifests.add(key);
                toFetchRootTrees.add((ObjectId)manifest2Tree.get(key));
            }
            if (requiredManifests.isEmpty()) {
                TransferStatistics transferStatistics = stats;
                return transferStatistics;
            }
            LinkedHashSet<ObjectId> requiredTrees = new LinkedHashSet<ObjectId>();
            toFetchRootTrees.forEach(t -> requiredTrees.addAll(rh.getRequiredTrees((ObjectId)t)));
            ObjectExistsOperation.Result treeResult = this.execute(new ObjectExistsOperation().addAll(requiredTrees));
            Set<ObjectId> requiredObjects = new LinkedHashSet<ObjectId>();
            if (!treeResult.missing.isEmpty()) {
                requiredObjects = rh.getRequiredObjects(treeResult.missing, treeResult.existing);
            }
            ObjectExistsOperation.Result objectResult = this.execute(new ObjectExistsOperation().addAll(requiredObjects));
            TransferStatistics fetchStats = this.fetch(rh, objectResult.missing, requiredManifests);
            stats.transferSize = fetchStats.transferSize;
            stats.sumManifests = fetchStats.sumManifests;
            stats.sumMissingObjects = fetchStats.sumMissingObjects;
            stats.sumTrees = requiredTrees.size();
            stats.sumMissingTrees = treeResult.missing.size();
        }
        finally {
            stats.duration = Duration.between(start, Instant.now()).toMillis();
        }
        return stats;
    }

    public FetchOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public FetchOperation addManifest(Collection<Manifest.Key> keys) {
        this.manifests.addAll(keys);
        return this;
    }

    public FetchOperation setHiveName(String name) {
        this.hiveName = name;
        return this;
    }

    public SortedSet<Manifest.Key> getManifests() {
        return this.manifests;
    }

    private TransferStatistics fetch(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) throws IOException {
        try {
            return this.fetchAsStream(rh, objects, manifests);
        }
        catch (UnsupportedOperationException ex) {
            return this.fetchAsZip(rh, objects, manifests);
        }
    }

    private TransferStatistics fetchAsZip(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) throws IOException {
        Path z = rh.fetch(objects, manifests);
        try {
            BHive zHive = new BHive(UriBuilder.fromUri("jar:" + z.toUri()).build(new Object[0]), null, this.getActivityReporter());
            try {
                TransferStatistics t = zHive.execute(new CopyOperation().setDestinationHive(this).setPartialAllowed(false));
                t.transferSize = Files.size(z);
                TransferStatistics transferStatistics = t;
                zHive.close();
                return transferStatistics;
            }
            catch (Throwable throwable) {
                try {
                    zHive.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Files.deleteIfExists(z);
        }
    }

    private TransferStatistics fetchAsStream(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) {
        InputStream stream = rh.fetchAsStream(objects, manifests);
        return this.execute(new ObjectReadOperation().stream(stream));
    }
}

