/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.BlobView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestRefScanOperation;
import io.bdeploy.bhive.op.ObjectWriteOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.bhive.op.remote.RemoteOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyOperation
public class PushOperation
extends RemoteOperation<TransferStatistics, PushOperation> {
    private static final Logger log = LoggerFactory.getLogger(PushOperation.class);
    private final Set<Manifest.Key> manifests = new LinkedHashSet<Manifest.Key>();
    private String hiveName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics call() throws Exception {
        TransferStatistics stats = new TransferStatistics();
        Instant start = Instant.now();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Pushing", -1L);
             RemoteBHive rh = RemoteBHive.forService(this.getRemote(), this.hiveName, this.getActivityReporter());){
            if (this.manifests.isEmpty()) {
                this.manifests.addAll((Collection<Manifest.Key>)this.execute(new ManifestListOperation()));
            }
            LinkedHashSet<Manifest.Key> allManifests = new LinkedHashSet<Manifest.Key>();
            for (Manifest.Key key : this.manifests) {
                allManifests.addAll(this.execute(new ManifestRefScanOperation().setManifest(key)).values());
                allManifests.add(key);
            }
            String[] manifestsAsArray = (String[])allManifests.stream().map(Manifest.Key::toString).toArray(String[]::new);
            SortedMap<Manifest.Key, ObjectId> manifest2Tree = rh.getManifestInventory(manifestsAsArray);
            allManifests.removeIf(manifest2Tree::containsKey);
            if (allManifests.isEmpty()) {
                TransferStatistics transferStatistics = stats;
                return transferStatistics;
            }
            Map<ObjectId, TreeView> allTrees = this.getAllTrees(allManifests);
            Set<ObjectId> missingTrees = rh.getMissingObjects(new LinkedHashSet<ObjectId>(allTrees.keySet()));
            List missingTreeViews = allTrees.values().stream().filter(t -> missingTrees.contains(t.getElementId())).collect(Collectors.toCollection(ArrayList::new));
            Collections.reverse(missingTreeViews);
            Set<ObjectId> requiredObjects = this.getRequiredObjects(missingTreeViews);
            Set<ObjectId> missingObjects = rh.getMissingObjects(requiredObjects);
            TransferStatistics pushStats = this.push(rh, missingObjects, allManifests);
            stats.sumTrees = allTrees.size();
            stats.sumManifests = allManifests.size();
            stats.sumMissingTrees = missingTrees.size();
            stats.transferSize = pushStats.transferSize;
            stats.sumMissingObjects = missingObjects.size();
        }
        finally {
            stats.duration = Duration.between(start, Instant.now()).toMillis();
        }
        return stats;
    }

    private Map<ObjectId, TreeView> getAllTrees(Set<Manifest.Key> manifests) {
        LinkedHashMap<ObjectId, TreeView> allTrees = new LinkedHashMap<ObjectId, TreeView>();
        for (Manifest.Key manifest : manifests) {
            TreeView view = this.execute(new ScanOperation().setManifest(manifest).setFollowReferences(false));
            view.visit(new TreeVisitor.Builder().onTree(t -> {
                if (t instanceof ManifestRefView) {
                    return false;
                }
                allTrees.put(t.getElementId(), (TreeView)t);
                return true;
            }).build());
        }
        return allTrees;
    }

    private Set<ObjectId> getRequiredObjects(List<TreeView> missingTrees) {
        LinkedHashSet<ObjectId> result = new LinkedHashSet<ObjectId>();
        for (TreeView view : missingTrees) {
            for (ElementView child : view.getChildren().values()) {
                if (child instanceof BlobView) {
                    result.add(child.getElementId());
                    continue;
                }
                if (!(child instanceof ManifestRefView)) continue;
                ManifestRefView refView = (ManifestRefView)child;
                result.add(refView.getReferenceId());
            }
            result.add(view.getElementId());
        }
        return result;
    }

    public PushOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public PushOperation addManifest(Collection<Manifest.Key> keys) {
        this.manifests.addAll(keys);
        return this;
    }

    public PushOperation setHiveName(String name) {
        this.hiveName = name;
        return this;
    }

    private TransferStatistics push(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) throws IOException {
        try {
            return this.pushAsStream(rh, objects, manifests);
        }
        catch (UnsupportedOperationException ex) {
            log.debug("Stream pushing not supported by target server", ex);
            return this.pushAsZip(rh, objects, manifests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransferStatistics pushAsZip(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) throws IOException {
        Path tmpHive = Files.createTempFile("push-", ".zip", new FileAttribute[0]);
        Files.delete(tmpHive);
        try {
            TransferStatistics s2;
            try (BHive emptyHive = new BHive(UriBuilder.fromUri("jar:" + tmpHive.toUri()).build(new Object[0]), null, this.getActivityReporter());){
                CopyOperation op = new CopyOperation().setDestinationHive(emptyHive).setPartialAllowed(true);
                objects.forEach(op::addObject);
                manifests.forEach(op::addManifest);
                s2 = this.execute(op);
            }
            s2.transferSize = Files.size(tmpHive);
            rh.push(tmpHive);
            TransferStatistics transferStatistics = s2;
            return transferStatistics;
        }
        finally {
            Files.deleteIfExists(tmpHive);
        }
    }

    private TransferStatistics pushAsStream(RemoteBHive rh, Set<ObjectId> objects, Set<Manifest.Key> manifests) {
        PipedInputStream input = new PipedInputStream();
        CompletableFuture barrier = new CompletableFuture();
        Thread thread = new Thread(() -> {
            try (PipedOutputStream output = new PipedOutputStream(input);){
                barrier.complete(null);
                this.execute(new ObjectWriteOperation().stream(output).manifests(manifests).objects(objects));
            }
            catch (Exception e) {
                log.warn("Cannot fully push content via stream", e);
            }
        });
        thread.setDaemon(true);
        thread.setName("Write-Objects");
        thread.start();
        barrier.join();
        return rh.pushAsStream(input);
    }
}

