/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op.remote;

import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.util.FormatHelper;

public class TransferStatistics {
    public long sumManifests;
    public long sumTrees;
    public long sumMissingTrees;
    public long sumMissingObjects;
    public long transferSize;
    public long duration;

    public DataResult toResult(DataResult result) {
        result.addField("Number of Manifests", this.sumManifests);
        result.addField("Number of reused Trees", this.sumTrees - this.sumMissingTrees);
        result.addField("Number of Objects", this.sumMissingObjects);
        result.addField("Transfer size (compr.)", FormatHelper.formatFileSize(this.transferSize));
        result.addField("Duration", FormatHelper.formatDuration(this.duration));
        result.addField("Transfer speed", FormatHelper.formatTransferRate(this.transferSize, this.duration));
        return result;
    }

    public Object toLogString() {
        return String.format("Total size %1$s, Manifests %2$s, Total files %3$s, Duration %4$s, Transfer Rate %5$s", FormatHelper.formatFileSize(this.transferSize), this.sumManifests, this.sumMissingObjects, FormatHelper.formatDuration(this.duration), FormatHelper.formatTransferRate(this.transferSize, this.duration));
    }
}

