/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ObjectExistsOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.ObjectReadOperation;
import io.bdeploy.bhive.op.ObjectWriteOperation;
import io.bdeploy.bhive.op.PruneOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBHiveAdapter
implements RemoteBHive {
    private static final Logger log = LoggerFactory.getLogger(LocalBHiveAdapter.class);
    private final BHive hive;
    private final ActivityReporter reporter;

    public LocalBHiveAdapter(BHive hive, ActivityReporter reporter) {
        this.hive = hive;
        this.reporter = reporter;
    }

    @Override
    public Set<ObjectId> getMissingObjects(Set<ObjectId> all) {
        try (ActivityReporter.Activity activity = this.reporter.start("Determining Objects");){
            Set<ObjectId> set = this.hive.execute(new ObjectExistsOperation().addAll(all)).missing;
            return set;
        }
    }

    @Override
    public Set<ObjectId> getRequiredObjects(Set<ObjectId> trees, Set<ObjectId> excludeTrees) {
        return this.hive.execute(new ObjectListOperation().addTree(trees).excludeTree(excludeTrees));
    }

    @Override
    public Set<ObjectId> getRequiredTrees(ObjectId tree) {
        TreeView snapshot = this.hive.execute(new ScanOperation().setTree(tree));
        LinkedHashSet<ObjectId> treeIds = new LinkedHashSet<ObjectId>();
        snapshot.visitDfs(new TreeVisitor.Builder().onTree(x -> treeIds.add(x.getElementId())).build());
        return treeIds;
    }

    @Override
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... names) {
        TreeSet mfs = new TreeSet();
        if (names.length == 0) {
            mfs.addAll(this.hive.execute(new ManifestListOperation()));
        } else {
            for (String name : names) {
                mfs.addAll(this.hive.execute(new ManifestListOperation().setManifestName(name)));
            }
        }
        TreeMap<Manifest.Key, ObjectId> result = new TreeMap<Manifest.Key, ObjectId>();
        for (Manifest.Key key : mfs) {
            result.put(key, this.hive.execute(new ManifestLoadOperation().setManifest(key)).getRoot());
        }
        return result;
    }

    @Override
    public void removeManifest(Manifest.Key key) {
        this.hive.execute(new ManifestDeleteOperation().setToDelete(key));
    }

    @Override
    public void prune() {
        this.hive.execute(new PruneOperation());
    }

    @Override
    public void push(Path zipedHive) {
        if (!PathHelper.exists(zipedHive)) {
            throw new IllegalArgumentException("File does not exist: " + zipedHive);
        }
        try (BHive packed = new BHive(UriBuilder.fromUri("jar:" + zipedHive.toUri()).build(new Object[0]), null, this.reporter);){
            packed.execute(new CopyOperation().setDestinationHive(this.hive).setPartialAllowed(false));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot push to local repository", e);
        }
    }

    @Override
    public TransferStatistics pushAsStream(InputStream in) {
        try (BHiveTransactions.Transaction t = this.hive.getTransactions().begin();){
            TransferStatistics transferStatistics = this.hive.execute(new ObjectReadOperation().stream(in));
            return transferStatistics;
        }
    }

    @Override
    public Path fetch(Set<ObjectId> requiredObjects, Set<Manifest.Key> manifestsToFetch) {
        try {
            Path tmpHive = Files.createTempFile("fetch-", ".zip", new FileAttribute[0]);
            Files.delete(tmpHive);
            try (BHive emptyHive = new BHive(UriBuilder.fromUri("jar:" + tmpHive.toUri()).build(new Object[0]), null, this.reporter);){
                CopyOperation op = new CopyOperation().setDestinationHive(emptyHive).setPartialAllowed(true);
                requiredObjects.forEach(op::addObject);
                manifestsToFetch.forEach(op::addManifest);
                this.hive.execute(op);
            }
            return tmpHive;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot fetch from local repository", e);
        }
    }

    @Override
    public InputStream fetchAsStream(Set<ObjectId> objects, Set<Manifest.Key> manifests) {
        PipedInputStream input = new PipedInputStream();
        CompletableFuture barrier = new CompletableFuture();
        Thread thread = new Thread(() -> {
            try (PipedOutputStream output = new PipedOutputStream(input);){
                barrier.complete(null);
                this.hive.execute(new ObjectWriteOperation().stream(output).manifests(manifests).objects(objects));
            }
            catch (IOException e) {
                log.warn("Cannot fully send content to fetching client via stream", e);
            }
        });
        thread.setDaemon(true);
        thread.setName("Write-Objects");
        thread.start();
        barrier.join();
        return input;
    }

    @Override
    public void close() {
        this.hive.close();
    }
}

