/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.LocalBHiveAdapter;
import io.bdeploy.bhive.remote.jersey.JerseyRemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import java.util.SortedMap;

public interface RemoteBHive
extends AutoCloseable {
    public Set<ObjectId> getMissingObjects(Set<ObjectId> var1);

    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... var1);

    public void removeManifest(Manifest.Key var1);

    public void prune();

    public Set<ObjectId> getRequiredObjects(Set<ObjectId> var1, Set<ObjectId> var2);

    public Set<ObjectId> getRequiredTrees(ObjectId var1);

    public void push(Path var1);

    public TransferStatistics pushAsStream(InputStream var1);

    public Path fetch(Set<ObjectId> var1, Set<Manifest.Key> var2);

    public InputStream fetchAsStream(Set<ObjectId> var1, Set<Manifest.Key> var2);

    public static RemoteBHive forService(RemoteService svc, String name, ActivityReporter reporter) {
        switch (svc.getUri().getScheme().toLowerCase()) {
            case "file": 
            case "jar": {
                return new LocalBHiveAdapter(new BHive(svc.getUri(), null, reporter), reporter);
            }
            case "https": {
                return new JerseyRemoteBHive(svc, name, reporter);
            }
        }
        throw new UnsupportedOperationException("scheme " + svc.getUri().getScheme() + " not supported");
    }

    @Override
    public void close();
}

