/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.common.security.RequiredPermission;
import io.bdeploy.common.security.ScopedPermission;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.InputStream;
import java.util.Set;
import java.util.SortedMap;

@Path(value="/hive")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface BHiveResource {
    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/manifests")
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... var1);

    @POST
    @Path(value="/manifest_remove")
    @RequiredPermission(permission=ScopedPermission.Permission.WRITE)
    public void removeManifest(Manifest.Key var1);

    @POST
    @Path(value="/prune")
    public void prune();

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/obj_missing")
    public Set<ObjectId> getMissingObjects(Set<ObjectId> var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/tree_objects")
    public Set<ObjectId> getRequiredObjects(ObjectListSpec var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/tree_trees")
    public Set<ObjectId> getRequiredTrees(ObjectId var1);

    @PUT
    @Path(value="/push")
    @Consumes(value={"application/octet-stream"})
    @RequiredPermission(permission=ScopedPermission.Permission.WRITE)
    public void push(java.nio.file.Path var1);

    @PUT
    @Path(value="/pushAsStream")
    @Produces(value={"application/json"})
    @Consumes(value={"application/octet-stream"})
    @RequiredPermission(permission=ScopedPermission.Permission.WRITE)
    public TransferStatistics pushAsStream(InputStream var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/fetch")
    @Produces(value={"application/octet-stream"})
    public java.nio.file.Path fetch(FetchSpec var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/fetchAsStream")
    @Produces(value={"application/octet-stream"})
    public InputStream fetchAsStream(FetchSpec var1);

    public static class ObjectListSpec {
        Set<ObjectId> trees;
        Set<ObjectId> excludeTrees;
    }

    public static class FetchSpec {
        Set<ObjectId> requiredObjects;
        Set<Manifest.Key> manifestsToFetch;
    }
}

