/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.LocalBHiveAdapter;
import io.bdeploy.bhive.remote.jersey.BHiveResource;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.jersey.JerseyPathWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveResourceImpl
implements BHiveResource {
    private static final Logger log = LoggerFactory.getLogger(BHiveResourceImpl.class);
    private final LocalBHiveAdapter wrapper;

    public BHiveResourceImpl(BHive hive, ActivityReporter reporter) {
        this.wrapper = new LocalBHiveAdapter(hive, reporter);
    }

    @Override
    public Set<ObjectId> getMissingObjects(Set<ObjectId> all) {
        return this.wrapper.getMissingObjects(all);
    }

    @Override
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... names) {
        return this.wrapper.getManifestInventory(names);
    }

    @Override
    public void removeManifest(Manifest.Key key) {
        this.wrapper.removeManifest(key);
    }

    @Override
    public void prune() {
        this.wrapper.prune();
    }

    @Override
    public Set<ObjectId> getRequiredObjects(BHiveResource.ObjectListSpec spec) {
        return this.wrapper.getRequiredObjects(spec.trees, spec.excludeTrees);
    }

    @Override
    public Set<ObjectId> getRequiredTrees(ObjectId tree) {
        return this.wrapper.getRequiredTrees(tree);
    }

    @Override
    public void push(Path zipedHive) {
        try {
            this.wrapper.push(zipedHive);
        }
        finally {
            block8: {
                try {
                    Files.delete(zipedHive);
                }
                catch (IOException e) {
                    log.warn("cannot delete {}", (Object)zipedHive);
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Exception: ", e);
                }
            }
        }
    }

    @Override
    public TransferStatistics pushAsStream(InputStream in) {
        return this.wrapper.pushAsStream(in);
    }

    @Override
    @JerseyPathWriter.DeleteAfterWrite
    public Path fetch(BHiveResource.FetchSpec spec) {
        return this.wrapper.fetch(spec.requiredObjects, spec.manifestsToFetch);
    }

    @Override
    public InputStream fetchAsStream(BHiveResource.FetchSpec spec) {
        return this.wrapper.fetchAsStream(spec.requiredObjects, spec.manifestsToFetch);
    }
}

