/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.bhive.remote.jersey.BHiveJacksonModule;
import io.bdeploy.bhive.remote.jersey.BHiveLocator;
import io.bdeploy.bhive.remote.jersey.BHiveResource;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.jersey.JerseyClientFactory;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.client.ResponseProcessingException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import java.util.SortedMap;

public class JerseyRemoteBHive
implements RemoteBHive {
    public static final BHiveJacksonModule HIVE_JACKSON_MODULE = new BHiveJacksonModule();
    public static final String DEFAULT_NAME = "default";
    private final BHiveResource client;

    public JerseyRemoteBHive(RemoteService service, String name, ActivityReporter reporter) {
        JerseyClientFactory jcf = JerseyClientFactory.get(service);
        jcf.register(HIVE_JACKSON_MODULE);
        jcf.setReporter(reporter);
        this.client = jcf.getProxyClient(BHiveLocator.class, new Object[0]).getNamedHive(name == null ? DEFAULT_NAME : name);
    }

    @Override
    public Set<ObjectId> getMissingObjects(Set<ObjectId> all) {
        return this.client.getMissingObjects(all);
    }

    @Override
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... names) {
        return this.client.getManifestInventory(names);
    }

    @Override
    public void removeManifest(Manifest.Key key) {
        this.client.removeManifest(key);
    }

    @Override
    public void prune() {
        this.client.prune();
    }

    @Override
    public Set<ObjectId> getRequiredObjects(Set<ObjectId> trees, Set<ObjectId> excludeTrees) {
        BHiveResource.ObjectListSpec spec = new BHiveResource.ObjectListSpec();
        spec.trees = trees;
        spec.excludeTrees = excludeTrees;
        return this.client.getRequiredObjects(spec);
    }

    @Override
    public Set<ObjectId> getRequiredTrees(ObjectId tree) {
        return this.client.getRequiredTrees(tree);
    }

    @Override
    public void push(Path zipedHive) {
        this.client.push(zipedHive);
    }

    @Override
    public TransferStatistics pushAsStream(InputStream in) {
        try {
            return this.client.pushAsStream(in);
        }
        catch (NotFoundException | ResponseProcessingException nfe) {
            throw new UnsupportedOperationException("Pushing as stream not supported", nfe);
        }
    }

    @Override
    public Path fetch(Set<ObjectId> objects, Set<Manifest.Key> manifests) {
        BHiveResource.FetchSpec spec = new BHiveResource.FetchSpec();
        spec.requiredObjects = objects;
        spec.manifestsToFetch = manifests;
        return this.client.fetch(spec);
    }

    @Override
    public InputStream fetchAsStream(Set<ObjectId> objects, Set<Manifest.Key> manifests) {
        try {
            BHiveResource.FetchSpec spec = new BHiveResource.FetchSpec();
            spec.requiredObjects = objects;
            spec.manifestsToFetch = manifests;
            return this.client.fetchAsStream(spec);
        }
        catch (NotFoundException nfe) {
            throw new UnsupportedOperationException("Fetching as stream not supported", nfe);
        }
    }

    @Override
    public void close() {
    }
}

