/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public final class ActivitySnapshot {
    public static final TypeReference<List<ActivitySnapshot>> LIST_TYPE = new TypeReference<List<ActivitySnapshot>>(){};
    public final String uuid;
    public final String name;
    public final List<String> scope;
    public final long duration;
    public final long max;
    public final long current;
    public final boolean cancel;
    public final String parentUuid;
    public final String user;

    @JsonCreator
    public ActivitySnapshot(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="duration") long duration, @JsonProperty(value="max") long max, @JsonProperty(value="current") long current, @JsonProperty(value="scope") List<String> scope, @JsonProperty(value="cancel") boolean cancel, @JsonProperty(value="parentUuid") String parentUuid, @JsonProperty(value="user") String user) {
        this.uuid = uuid;
        this.name = name + (cancel ? " (cancel requested)" : "");
        this.duration = duration;
        this.max = max;
        this.current = current;
        this.scope = scope;
        this.cancel = cancel;
        this.parentUuid = parentUuid;
        this.user = user;
    }

    public String toString() {
        return String.format("[%1$08d] %2$-70s %3$8d/%4$8d", this.duration, this.name, this.current, this.max);
    }
}

