/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableScope {
    private static final Logger log = LoggerFactory.getLogger(RetryableScope.class);
    private final AtomicLong iterationCountMax = new AtomicLong(10L);
    private final AtomicLong iterationTimeoutMs = new AtomicLong(100L);
    private Consumer<Exception> onException = e -> {
        log.debug("Retriable scope received exception: ", (Throwable)e);
        try {
            Thread.sleep(this.iterationTimeoutMs.get());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("While handling retry: ", ie);
        }
    };

    private RetryableScope() {
    }

    public static RetryableScope create() {
        return new RetryableScope();
    }

    public RetryableScope withExceptionHandler(Consumer<Exception> e) {
        this.onException = e;
        return this;
    }

    public RetryableScope withDelay(long ms) {
        this.iterationTimeoutMs.set(ms);
        return this;
    }

    public RetryableScope withMaxRetries(long amount) {
        this.iterationCountMax.set(amount);
        return this;
    }

    public void run(Runnable action) {
        boolean madeIt = false;
        RuntimeException lastException = null;
        for (long i = 0L; i < this.iterationCountMax.get(); ++i) {
            try {
                action.run();
                madeIt = true;
                break;
            }
            catch (RuntimeException e) {
                lastException = e;
                this.onException.accept(e);
                continue;
            }
        }
        if (!madeIt) {
            if (lastException != null) {
                throw lastException;
            }
            throw new IllegalStateException("Out of retries");
        }
    }
}

