/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(TaskSynchronizer.class);
    private final Map<Comparable<?>, Future<?>> tasks = new TreeMap((a, b) -> {
        String clsBName;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? 1 : -1;
        }
        String clsAName = a.getClass().getName();
        int x = clsAName.compareTo(clsBName = b.getClass().getName());
        if (x != 0) {
            return x;
        }
        return a.compareTo(b);
    });

    public synchronized boolean isPerforming(Comparable<?> key) {
        return this.tasks.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T perform(Comparable<?> key, Callable<T> task) {
        Future<?> existing;
        if (key == null) {
            log.warn("Null key not allowed in future", new IllegalStateException("Null key, task: " + task));
        }
        CompletableFuture tracker = null;
        TaskSynchronizer taskSynchronizer = this;
        synchronized (taskSynchronizer) {
            existing = this.tasks.get(key);
            if (existing == null) {
                tracker = new CompletableFuture();
                this.tasks.put(key, tracker);
            }
        }
        if (existing != null) {
            try {
                return (T)existing.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Task interrupted", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Task failed", e);
            }
        }
        try {
            T result = task.call();
            tracker.complete(null);
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            tracker.completeExceptionally(e);
            throw e;
        }
        catch (Exception e) {
            tracker.completeExceptionally(e);
            throw new RuntimeException(e);
        }
        finally {
            TaskSynchronizer taskSynchronizer2 = this;
            synchronized (taskSynchronizer2) {
                this.tasks.remove(key);
            }
        }
    }
}

