/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.audit;

import io.bdeploy.common.cfg.Configuration;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.security.Principal;
import java.util.Map;
import java.util.TreeMap;

public class AuditRecord {
    public final String who;
    public final String what;
    public final String parameters;
    public final String method;
    public final String message;
    public final Severity severity;

    private AuditRecord(Builder builder) {
        this.parameters = builder.parameters.isEmpty() ? "No parameters" : builder.parameters.toString();
        this.what = builder.what;
        this.method = builder.method;
        this.message = builder.message;
        this.severity = builder.severity;
        this.who = builder.who == null ? "<UNKNOWN>" : builder.who;
    }

    public String toString() {
        return "Audit record [what=" + this.what + " method=" + this.method + " severity=" + this.severity + " who=" + this.who + " parameters=" + this.parameters + "]";
    }

    public static class Builder {
        private final Map<String, String> parameters = new TreeMap<String, String>();
        private String who;
        private String what;
        private String method = "-";
        private String message = "Execute";
        private Severity severity = Severity.NORMAL;

        public static Builder fromRequest(ContainerRequestContext context) {
            Builder builder = new Builder();
            UriInfo uriInfo = context.getUriInfo();
            builder.setWho(context.getSecurityContext());
            builder.setWhat(uriInfo.getPath(true));
            builder.setMethod(context.getMethod());
            uriInfo.getQueryParameters(true).forEach((k, v) -> builder.addParameter("q:" + k, v.toString()));
            uriInfo.getPathParameters(true).forEach((k, v) -> builder.addParameter("p:" + k, v.toString()));
            return builder;
        }

        public static Builder fromSystem() {
            Builder builder = new Builder();
            builder.setWho(System.getProperty("user.name"));
            return builder;
        }

        public Builder setWho(SecurityContext context) {
            Principal p;
            if (context != null && (p = context.getUserPrincipal()) != null) {
                this.who = p.getName();
            }
            return this;
        }

        public Builder setWho(String who) {
            this.who = who;
            return this;
        }

        public Builder setWhat(String what) {
            this.what = what;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder addParameter(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public Builder addParameters(Configuration cfg) {
            cfg.getAllRawObjects().forEach((k, v) -> this.addParameter((String)k, v.toString()));
            return this;
        }

        public Builder addParameters(Map<String, String> params) {
            this.parameters.putAll(params);
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public AuditRecord build() {
            return new AuditRecord(this);
        }
    }

    public static enum Severity {
        NORMAL,
        WARNING,
        ERROR;

    }
}

