/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.audit;

import io.bdeploy.common.audit.AuditRecord;
import io.bdeploy.common.audit.Auditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jAuditor
implements Auditor {
    private static final Logger log = LoggerFactory.getLogger(Slf4jAuditor.class);

    @Override
    public void close() {
    }

    @Override
    public void audit(AuditRecord rec) {
        MDC.put("WHO", rec.who);
        MDC.put("WHAT", rec.what);
        MDC.put("PARAMETERS", rec.parameters);
        MDC.put("METHOD", rec.method);
        switch (rec.severity) {
            case NORMAL: {
                log.info(rec.message);
                break;
            }
            case WARNING: {
                log.warn(rec.message);
                break;
            }
            case ERROR: {
                log.error(rec.message);
            }
        }
    }
}

