/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cfg;

import com.google.common.base.Splitter;
import io.bdeploy.common.cfg.ConfigValidationException;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.data.DataTable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class Configuration {
    private final Map<String, Object> objects = new TreeMap<String, Object>();
    private final Map<Method, Object> conversions = new HashMap<Method, Object>();

    public void add(String ... arguments) {
        for (String arg : arguments) {
            if (arg.startsWith("--")) {
                String stripped = arg.substring(2);
                int equalsIndex = stripped.indexOf(61);
                if (equalsIndex != -1) {
                    this.addKeyValueArgument(stripped, equalsIndex);
                    continue;
                }
                this.objects.put(stripped, Boolean.TRUE);
                continue;
            }
            throw new IllegalStateException("Unsupported argument format: " + arg);
        }
    }

    private void addKeyValueArgument(String stripped, int equalsIndex) {
        String key = stripped.substring(0, equalsIndex);
        String value = stripped.substring(equalsIndex + 1);
        if (this.objects.containsKey(key)) {
            Object existing = this.objects.get(key);
            if (existing instanceof List) {
                ((List)existing).add(value);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(existing);
                l.add(value);
                this.objects.put(key, l);
            }
        } else {
            this.objects.put(key, value);
        }
    }

    public Map<String, Object> getAllRawObjects() {
        return this.objects;
    }

    public void add(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.objects.put((String)k, v)));
    }

    public <T extends Annotation> T get(Class<? extends Annotation> target) {
        Annotation proxy = (Annotation)Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, this::doMap);
        ArrayList<Exception> validationProblems = new ArrayList<Exception>();
        for (Method m3 : target.getDeclaredMethods()) {
            try {
                this.doMap(proxy, m3, null);
            }
            catch (Exception e) {
                validationProblems.add(e);
            }
        }
        if (!validationProblems.isEmpty()) {
            ConfigValidationException collector = new ConfigValidationException();
            for (Exception problem : validationProblems) {
                collector.addSuppressed(problem);
            }
            throw collector;
        }
        return (T)proxy;
    }

    private Object doMap(Object proxy, Method method, Object[] arguments) {
        EnvironmentFallback fallback;
        Object value;
        String key = method.getName();
        ConfigurationNameMapping mapping = method.getAnnotation(ConfigurationNameMapping.class);
        if (mapping != null) {
            key = mapping.value();
        }
        if ((value = this.objects.get(key)) == null && !ToolBase.isTestMode() && (fallback = method.getAnnotation(EnvironmentFallback.class)) != null) {
            value = System.getenv(fallback.value());
        }
        if (value == null && !method.getReturnType().isAnnotation()) {
            return method.getDefaultValue();
        }
        return this.doConvert(method, value);
    }

    private Object doConvert(Method method, Object object) {
        Object conversion = this.conversions.get(method);
        if (conversion != null) {
            return conversion;
        }
        Validator validator = method.getAnnotation(Validator.class);
        Class<? extends ConfigValidator<?>>[] cvs = null;
        if (validator != null) {
            cvs = validator.value();
        }
        UnaryOperator<Object> mapper = this.getMapper(method);
        Class<?> returnType = method.getReturnType();
        if (object != null && returnType.isAssignableFrom(object.getClass())) {
            this.validateOrThrow(object, method, cvs);
            Object result = object;
            if (returnType.isAssignableFrom(String.class)) {
                result = mapper.apply(object);
            }
            this.conversions.put(method, result);
            return result;
        }
        if (returnType.isPrimitive() && !(object instanceof String)) {
            this.validateOrThrow(object, method, cvs);
            this.conversions.put(method, object);
            return object;
        }
        if (object instanceof List && returnType.isArray()) {
            List list = (List)object;
            Object targetArray = Array.newInstance(returnType.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(targetArray, i, this.convertType(returnType.getComponentType(), (String)list.get(i), mapper));
            }
            this.validateOrThrow(targetArray, method, cvs);
            this.conversions.put(method, targetArray);
            return targetArray;
        }
        if (!(object instanceof String) && !returnType.isAnnotation()) {
            throw new IllegalStateException(this.getParameterConfigurationHint(returnType, method.getName(), object));
        }
        conversion = this.convertType(returnType, (String)object, mapper);
        this.validateOrThrow(conversion, method, cvs);
        this.conversions.put(method, conversion);
        return conversion;
    }

    private String getParameterConfigurationHint(Class<?> returnType, String methodName, Object object) {
        StringBuilder hint = new StringBuilder();
        hint.append("Could not resolve " + methodName + " parameter. ");
        if (returnType.isArray()) {
            hint.append("Please specify parameter like this: " + methodName + "=<value1> " + methodName + "=<value2>... or like this: " + methodName + "=<value1>,<value2>... ");
        } else {
            hint.append("Please specify parameter like this: " + methodName + "=<value>. ");
        }
        hint.append("Illegal conversion from non-string object to different type: " + (Serializable)(object == null ? "null" : object.getClass()) + " to " + returnType);
        return hint.toString();
    }

    private UnaryOperator<Object> getMapper(Method method) {
        ConfigurationValueMapping mapping = method.getAnnotation(ConfigurationValueMapping.class);
        UnaryOperator mapper = s2 -> s2;
        if (mapping != null) {
            if (mapping.value() == ValueMapping.TO_LOWERCASE) {
                mapper = s2 -> s2.toString().toLowerCase();
            } else if (mapping.value() == ValueMapping.TO_UPPERCASE) {
                mapper = s2 -> s2.toString().toUpperCase();
            }
        }
        return mapper;
    }

    private void validateOrThrow(Object value, Method m3, Class<? extends ConfigValidator<?>>[] validators) {
        if (validators == null) {
            return;
        }
        for (Class<ConfigValidator<?>> clazz : validators) {
            try {
                ValidationMessage msg = clazz.getAnnotation(ValidationMessage.class);
                if (msg == null) {
                    throw new IllegalStateException("No validation message set on validator class: " + clazz);
                }
                ConfigValidator<?> v = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (v.validate(Configuration.cast(value))) continue;
                throw new IllegalArgumentException("--" + m3.getName() + ": " + String.format(msg.value(), value));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot validate value: " + value + " using validator: " + clazz, e);
            }
        }
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    private Object convertType(Class<?> target, String source, UnaryOperator<Object> mapper) {
        if (target.isAnnotation()) {
            return this.get(target);
        }
        if (source == null) {
            throw new IllegalArgumentException("Conversion of null source not possible");
        }
        if (target.equals(String.class)) {
            return mapper.apply(source);
        }
        if (target.equals(Long.TYPE)) {
            return Long.parseLong(source);
        }
        if (target.equals(Integer.TYPE)) {
            return Integer.parseInt(source);
        }
        if (target.equals(Short.TYPE)) {
            return Short.parseShort(source);
        }
        if (target.equals(Byte.TYPE)) {
            return Byte.parseByte(source);
        }
        if (target.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(source);
        }
        if (target.equals(Double.TYPE)) {
            return Double.parseDouble(source);
        }
        if (target.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(source));
        }
        if (target.equals(Character.TYPE)) {
            if (source.length() > 1) {
                throw new IllegalArgumentException("Character conversion with input length > 1: " + source);
            }
            return Character.valueOf(source.charAt(0));
        }
        if (target.isEnum()) {
            try {
                return target.getMethod("valueOf", String.class).invoke(null, mapper.apply(source));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException("internal error resolving enumeration literal for " + target + " '" + source + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }
        if (target.isArray()) {
            List<String> split = Splitter.on(',').trimResults().omitEmptyStrings().splitToList(source);
            Object targetArray = Array.newInstance(target.getComponentType(), split.size());
            for (int i = 0; i < split.size(); ++i) {
                Array.set(targetArray, i, this.convertType(target.getComponentType(), split.get(i), mapper));
            }
            return targetArray;
        }
        throw new IllegalStateException("Unsupported conversion to " + target);
    }

    public static void formatHelp(Class<? extends Annotation> cfg, DataTable target) {
        List declaredMethods = Arrays.asList(cfg.getDeclaredMethods()).stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        for (Method m3 : declaredMethods) {
            Help h2 = m3.getAnnotation(Help.class);
            ConfigurationNameMapping mapping = m3.getAnnotation(ConfigurationNameMapping.class);
            String name = m3.getName();
            if (mapping != null) {
                name = mapping.value();
            }
            EnvironmentFallback env = m3.getAnnotation(EnvironmentFallback.class);
            String envFb = "";
            if (env != null) {
                envFb = String.format(" (Environment variable '%1$s' is used as fallback if not given).", env.value());
            }
            String defVal = "";
            if (m3.getDefaultValue() != null && h2.arg()) {
                defVal = m3.getDefaultValue().getClass().isArray() ? Arrays.asList((Object[])m3.getDefaultValue()).toString() : m3.getDefaultValue().toString();
            }
            if (h2 != null) {
                target.row().cell(" --" + name + (h2.arg() ? "=ARG" : "")).cell(h2.value() + envFb).cell(defVal).build();
                continue;
            }
            target.row().cell(" --" + name).cell(env != null ? envFb.substring(1) : "").cell(defVal).build();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConfigurationNameMapping {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface EnvironmentFallback {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Validator {
        public Class<? extends ConfigValidator<?>>[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConfigurationValueMapping {
        public ValueMapping value();
    }

    public static enum ValueMapping {
        TO_UPPERCASE,
        TO_LOWERCASE;

    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ValidationMessage {
        public String value() default "Validation failed for $1%s";
    }

    @FunctionalInterface
    public static interface ConfigValidator<T> {
        public boolean validate(T var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Help {
        public String value();

        public boolean arg() default true;
    }
}

