/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cfg;

import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.util.OsHelper;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration.ValidationMessage(value="The given root directory does not belong to the current user: %s")
public class PathOwnershipValidator
implements Configuration.ConfigValidator<String> {
    private static final Logger log = LoggerFactory.getLogger(PathOwnershipValidator.class);

    @Override
    public boolean validate(String value) {
        if (OsHelper.getRunningOs() == OsHelper.OperatingSystem.WINDOWS) {
            return true;
        }
        Path target = Paths.get(value, new String[0]);
        if (!PathHelper.exists(target)) {
            return true;
        }
        try {
            UserPrincipal current = target.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(System.getProperty("user.name"));
            UserPrincipal owner = Files.getOwner(target, new LinkOption[0]);
            boolean ok = owner.getName().equals(current.getName());
            if (!ok) {
                log.warn("Path ownership validation failed: user={}, owner={}", (Object)current, (Object)owner);
            }
            return ok;
        }
        catch (UnsupportedOperationException ex) {
            log.debug("Checking directory ownership not possible", ex);
            return true;
        }
        catch (IOException e) {
            log.warn("Cannot check directory ownership of {}", (Object)target, (Object)e);
            return false;
        }
    }
}

