/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli;

import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.audit.Auditor;
import io.bdeploy.common.audit.NullAuditor;
import io.bdeploy.common.cfg.ConfigValidationException;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.cli.data.DataFormat;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.ExitCode;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.metrics.Metrics;
import io.bdeploy.common.util.VersionHelper;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

@SuppressFBWarnings
public abstract class ToolBase {
    private static final String[] LOGO = new String[]{"\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510  ", "\u2502                   \u2584\u2584\u2584        \u2502  ", "\u2502                 \u2588\u2588\u2588\u2588\u2588\u2588       \u2502  ", "\u2502   \u2588\u2584           \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u258c      \u2502  ", "\u2502     \u2580\u2588        \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588       \u2502  ", "\u2502 \u2580\u2580\u2580\u2580\u2584\u2584\u2580      \u2590\u2588\u2588\u2588\u2588\u2588\u2588\u2588        \u2502  ", "\u2502       \u2580\u2588\u2584\u2584\u2584  \u2590\u2588\u2588\u2588\u2588\u2580          \u2502  ", "\u2502       \u2584\u2588\u2588\u2588\u2588\u2588  \u2580\u2580             \u2502  ", "\u2502       \u2580\u2588\u2588\u2588\u2588\u2588 \u2590\u2588\u2588  \u2588\u2588\u258c        \u2502  ", "\u2502     \u2590\u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u258c \u2590\u2588\u2588\u258c\u2590\u2588\u2588     \u2502  ", "\u2502      \u2588\u2588\u2588\u2588\u2580  \u2588\u2588\u2588 \u2584\u2588\u2588\u2588 \u2588\u2588\u2588\u2584    \u2502  ", "\u2502                \u2584\u2588\u2588\u2588 \u2584\u2588\u2588\u2580     \u2502  ", "\u2502                              \u2502  ", "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518  "};
    private static boolean testMode = false;
    private static boolean testModeLLM = false;
    private static boolean failWithException = false;
    private final Map<String, Class<? extends CliTool>> tools = new TreeMap<String, Class<? extends CliTool>>();
    private Function<Path, Auditor> auditorFactory;

    public static void setTestMode(boolean test) {
        testMode = test;
        testModeLLM = test;
    }

    public static void setTestModeForLLM(boolean test) {
        testModeLLM = test;
    }

    public static void setFailWithException(boolean fail) {
        failWithException = fail;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static boolean isTestModeLLM() {
        return testModeLLM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolMain(String ... args) throws Exception {
        ActivityReporter.Null defaultReporter;
        ActivityReporter.Stream streamReporter = new ActivityReporter.Stream(System.out);
        ActivityReporter reporter = defaultReporter = new ActivityReporter.Null();
        PrintStream output = null;
        PrintStream reporterOutput = null;
        DataFormat dataMode = DataFormat.TEXT;
        RenderableResult result = null;
        boolean verbose = false;
        boolean closeOutput = false;
        RuntimeException exc = null;
        try {
            CliTool instance;
            Class<?> clazz;
            ToolDefaultVerbose defVerbose;
            int toolArgNum = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    switch (args[i]) {
                        case "-vv": {
                            streamReporter.setVerboseSummary(true);
                            reporter = null;
                            verbose = true;
                            break;
                        }
                        case "-v": {
                            verbose = true;
                            break;
                        }
                        case "-q": {
                            reporter = new ActivityReporter.Null();
                            verbose = false;
                            break;
                        }
                        case "-o": {
                            String of = args[++i];
                            closeOutput = true;
                            output = new PrintStream(new File(of), StandardCharsets.UTF_8.name());
                            break;
                        }
                        case "-op": {
                            String opf = args[++i];
                            reporterOutput = new PrintStream(new File(opf), StandardCharsets.UTF_8.name());
                            streamReporter = new ActivityReporter.Stream(reporterOutput);
                            streamReporter.setVerboseSummary(reporter == null);
                            break;
                        }
                        case "--csv": {
                            dataMode = DataFormat.CSV;
                            break;
                        }
                        case "--json": {
                            dataMode = DataFormat.JSON;
                            break;
                        }
                        case "--version": {
                            String version = VersionHelper.getVersion().toString();
                            System.out.println(version);
                            return;
                        }
                    }
                    continue;
                }
                toolArgNum = i;
                break;
            }
            if (reporter == null) {
                reporter = streamReporter;
            }
            if (output == null) {
                output = System.out;
            }
            if (args.length <= toolArgNum || this.tools.get(args[toolArgNum]) == null) {
                int logo = 0;
                System.out.println(LOGO[logo++]);
                System.out.println(LOGO[logo++] + "BHive & BDeploy");
                System.out.println(LOGO[logo++] + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                System.out.println(LOGO[logo++] + "Usage: $0 <options...> <tool> <args...>");
                System.out.println(LOGO[logo++]);
                System.out.println(LOGO[logo++] + "Options:");
                System.out.println(LOGO[logo++] + "  -q      Be quiet - no progress reporting.");
                System.out.println(LOGO[logo++] + "  -v|-vv  Be verbose. No effect if -q is given as well.");
                System.out.println(LOGO[logo++] + "  -o <f>  Write output to file <f>. No effect on progress output.");
                System.out.println(LOGO[logo++] + "  -op <f> Write progress tracking output to file <f>. No");
                System.out.println(LOGO[logo++] + "          effect on normal output.");
                System.out.println(LOGO[logo++] + "  --csv   Write data tables in CSV format");
                System.out.println(LOGO[logo++] + "  --json  Write data tables in JSON format");
                System.out.println(LOGO[logo++]);
                System.out.println("Tools:");
                System.out.println();
                Map grouped = this.tools.entrySet().stream().collect(Collectors.groupingBy(e -> this.getToolCategory((Class)e.getValue()), TreeMap::new, Collectors.toList()));
                grouped.entrySet().stream().forEach(group -> {
                    System.out.println("  " + (String)group.getKey() + ":");
                    DataTable table = DataFormat.TEXT.createTable(System.out);
                    table.setIndentHint(5).setHideHeadersHint(true).setLineWrapHint(true);
                    table.column("Tool", 30).column("Description", 60);
                    ((List)group.getValue()).stream().forEach(e -> {
                        List<String> names = ToolBase.namesOf((Class)e.getValue());
                        if (names.get(0).equals(e.getKey())) {
                            Configuration.Help h2 = ((Class)e.getValue()).getAnnotation(Configuration.Help.class);
                            table.row().cell(e.getKey()).cell(h2.value() != null ? h2.value() : "").build();
                        } else {
                            table.row().cell(e.getKey()).cell("DEPRECATED. Alias for '" + names.get(0) + "'").build();
                        }
                    });
                    table.render();
                    System.out.println();
                });
                if (failWithException || testMode) {
                    throw new IllegalArgumentException("Wrong number of arguments");
                }
                System.exit(ExitCode.ERROR.getCode());
            }
            if (!((defVerbose = (clazz = (instance = this.getTool(Arrays.copyOfRange(args, toolArgNum, args.length))).getClass()).getAnnotation(ToolDefaultVerbose.class)) == null || verbose || verbose && reporter == streamReporter || reporter != defaultReporter)) {
                verbose = true;
                if (defVerbose.value()) {
                    reporter = streamReporter;
                }
            }
            if (reporter == streamReporter) {
                streamReporter.beginReporting();
            }
            instance.setOutput(output);
            instance.setVerbose(verbose);
            instance.setActivityReporter(reporter);
            instance.setDataFormat(dataMode);
            if (instance instanceof ConfiguredCliTool && ((ConfiguredCliTool)instance).getRawConfiguration().getAllRawObjects().containsKey("help")) {
                ((ConfiguredCliTool)instance).helpAndFail("Help:");
            }
            try (Timer.Context timer = Metrics.getMetric(Metrics.MetricGroup.CLI).timer(instance.getClass().getSimpleName() + "/" + args[toolArgNum]).time();){
                result = instance.run();
                if (result != null) {
                    result.render();
                }
            }
        }
        catch (RuntimeException t) {
            exc = t;
        }
        finally {
            if (closeOutput && output != null) {
                output.close();
            }
            streamReporter.stopReporting();
            if (reporterOutput != null) {
                reporterOutput.close();
            }
        }
        if (failWithException || testMode) {
            if (exc != null) {
                throw exc;
            }
            return;
        }
        if (exc != null) {
            DataResult res = dataMode.createResult(output);
            res.setException(exc);
            res.render();
            System.exit(ExitCode.ERROR.getCode());
        }
        if (result == null) {
            System.exit(ExitCode.OK.getCode());
        } else {
            System.exit(result.getExitCode().getCode());
        }
    }

    private String getToolCategory(Class<? extends CliTool> clazz) {
        ToolCategory annotation = clazz.getAnnotation(ToolCategory.class);
        if (annotation == null || annotation.value() == null) {
            return "Ungrouped Tools";
        }
        return annotation.value();
    }

    public CliTool getTool(String ... args) throws Exception {
        Class<? extends CliTool> tool = this.tools.get(args[0]);
        CliTool instance = tool.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        instance.setAuditorFactory(this.auditorFactory);
        if (instance instanceof ConfiguredCliTool) {
            Configuration cfg = new Configuration();
            if (args.length > 1) {
                cfg.add(Arrays.copyOfRange(args, 1, args.length));
            }
            ConfiguredCliTool toConfig = (ConfiguredCliTool)instance;
            toConfig.setConfig(cfg);
        } else if (instance instanceof NativeCliTool) {
            ((NativeCliTool)instance).setArguments(Arrays.copyOfRange(args, 1, args.length));
        }
        return instance;
    }

    public static List<String> namesOf(Class<? extends CliTool> tool) {
        CliTool.CliName name = tool.getAnnotation(CliTool.CliName.class);
        if (name == null || name.value() == null) {
            throw new IllegalStateException("Cannot find annotation on " + tool);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(name.value());
        if (name.alias().length > 0) {
            result.addAll(Arrays.asList(name.alias()));
        }
        return result;
    }

    public void register(Class<? extends CliTool> tool) {
        ToolBase.namesOf(tool).forEach(name -> this.tools.put((String)name, tool));
    }

    public void setAuditorFactory(Function<Path, Auditor> auditorFactory) {
        this.auditorFactory = auditorFactory;
    }

    public static abstract class CliTool {
        private ActivityReporter reporter;
        private Function<Path, Auditor> auditorFactory = p -> new NullAuditor();
        private PrintStream output = System.out;
        private boolean verbose;
        private DataFormat dataFormat = DataFormat.TEXT;

        public void setActivityReporter(ActivityReporter reporter) {
            this.reporter = reporter;
        }

        protected ActivityReporter getActivityReporter() {
            return this.reporter;
        }

        public void setAuditorFactory(Function<Path, Auditor> auditorFactory) {
            this.auditorFactory = auditorFactory == null ? p -> new NullAuditor() : auditorFactory;
        }

        protected Function<Path, Auditor> getAuditorFactory() {
            return this.auditorFactory;
        }

        public void setDataFormat(DataFormat dataMode) {
            this.dataFormat = dataMode;
        }

        protected DataFormat getDataFormat() {
            return this.dataFormat;
        }

        protected DataTable createDataTable() {
            return this.dataFormat.createTable(this.output);
        }

        protected DataResult createSuccess() {
            return this.createResultWithSuccessMessage("Success");
        }

        protected DataResult createNoOp() {
            return this.createResultWithSuccessMessage("Nothing to do (missing arguments?)");
        }

        protected DataResult createEmptyResult() {
            return this.dataFormat.createResult(this.output);
        }

        protected DataResult createResultWithSuccessMessage(String message) {
            DataResult result = this.dataFormat.createResult(this.output);
            result.setMessage(message);
            result.setExitCode(ExitCode.OK);
            return result;
        }

        protected DataResult createResultWithErrorMessage(String message) {
            DataResult result = this.dataFormat.createResult(this.output);
            result.setMessage(message);
            result.setExitCode(ExitCode.ERROR);
            return result;
        }

        public void setOutput(PrintStream output) {
            this.output = output;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        protected boolean isVerbose() {
            return this.verbose;
        }

        protected PrintStream out() {
            return this.output;
        }

        public abstract RenderableResult run();

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface CliName {
            public String value();

            public String[] alias() default {};
        }
    }

    @SuppressFBWarnings
    public static abstract class ConfiguredCliTool<T extends Annotation>
    extends CliTool {
        private final Class<T> configClass;
        private Configuration config;

        protected ConfiguredCliTool(Class<T> configClass) {
            this.configClass = configClass;
        }

        private void setConfig(Configuration config) {
            this.config = config;
        }

        protected Class<? extends Annotation> getPrimaryConfigClass() {
            return this.configClass;
        }

        protected List<Class<? extends Annotation>> getConfigsForHelp() {
            return Collections.singletonList(this.configClass);
        }

        protected <X extends Annotation> X getConfig(Class<X> clazz) {
            try {
                return (X)this.config.get(clazz);
            }
            catch (ConfigValidationException e) {
                this.out().println("Validation Issues Exist:");
                for (Throwable t : e.getSuppressed()) {
                    this.out().println("  " + t.getMessage());
                }
                this.out().println();
                throw e;
            }
        }

        protected Configuration getRawConfiguration() {
            return this.config;
        }

        @Override
        public final RenderableResult run() {
            return this.run(this.getConfig(this.configClass));
        }

        protected void helpAndFailIfMissing(Object argument, String message) {
            if (argument == null || argument.getClass().isArray() && Array.getLength(argument) == 0 || argument instanceof String && ((String)argument).isEmpty()) {
                this.helpAndFail("ERROR: " + message);
            }
        }

        protected void helpAndFail(String message) {
            Configuration.Help help;
            this.out().println();
            this.out().println(message);
            this.out().println();
            DataTable table = this.getDataFormat().createTable(this.out());
            String name = this.getClass().getSimpleName();
            CliTool.CliName annotation = this.getClass().getAnnotation(CliTool.CliName.class);
            if (annotation != null && annotation.value() != null) {
                name = annotation.value();
            }
            table.setCaption(name + (String)((help = this.getClass().getAnnotation(Configuration.Help.class)) != null && help.value() != null ? ": " + help.value() : ""));
            table.setLineWrapHint(true).setIndentHint(2);
            table.column("Argument", 20).column("Description", 70).column("Default", 10);
            List<Class<Annotation>> configsForHelp = this.getConfigsForHelp();
            for (int i = 0; i < configsForHelp.size(); ++i) {
                Class<Annotation> x = configsForHelp.get(i);
                Configuration.formatHelp(x, table);
                if (i == configsForHelp.size() - 1) continue;
                table.addHorizontalRuler();
            }
            table.render();
            if (failWithException || testMode) {
                throw new IllegalArgumentException(message);
            }
            System.exit(ExitCode.ERROR.getCode());
        }

        protected abstract RenderableResult run(T var1);
    }

    public static abstract class NativeCliTool
    extends CliTool {
        private String[] args;

        private void setArguments(String[] args) {
            this.args = args;
        }

        @Override
        public final RenderableResult run() {
            return this.run(this.args);
        }

        protected abstract RenderableResult run(String[] var1);
    }
}

