/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.DataResultCsv;
import io.bdeploy.common.cli.data.DataResultJson;
import io.bdeploy.common.cli.data.DataResultText;
import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.DataTableCsv;
import io.bdeploy.common.cli.data.DataTableJson;
import io.bdeploy.common.cli.data.DataTableText;
import java.io.PrintStream;

public enum DataFormat {
    TEXT,
    CSV,
    JSON;


    public DataTable createTable(PrintStream target) {
        switch (this) {
            case TEXT: {
                return new DataTableText(target);
            }
            case CSV: {
                return new DataTableCsv(target);
            }
            case JSON: {
                return new DataTableJson(target);
            }
        }
        throw new IllegalStateException("Unsupported DataFormat");
    }

    public DataResult createResult(PrintStream target) {
        switch (this) {
            case TEXT: {
                return new DataResultText(target);
            }
            case CSV: {
                return new DataResultCsv(target);
            }
            case JSON: {
                return new DataResultJson(target);
            }
        }
        throw new IllegalStateException("Unsupported DataFormat");
    }
}

