/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataResultBase;
import io.bdeploy.common.cli.data.DataTableColumn;
import io.bdeploy.common.cli.data.DataTableJson;
import io.bdeploy.common.util.ExceptionHelper;
import java.io.PrintStream;
import java.util.Map;

public class DataResultJson
extends DataResultBase {
    public DataResultJson(PrintStream output) {
        super(output);
    }

    @Override
    public void render() {
        this.out().println("{");
        if (this.getThrowable() != null) {
            if (this.getMessage() != null) {
                this.out().println("  \"message\": " + DataTableJson.quote(this.getMessage()) + ",");
            }
            this.out().println("  \"error\": " + DataTableJson.quote(ExceptionHelper.mapExceptionCausesToReason(this.getThrowable())));
        } else {
            if (this.getMessage() != null) {
                this.out().print("  \"message\": " + DataTableJson.quote(this.getMessage()));
                this.out().println(this.getFields().size() > 0 ? "," : "");
            }
            int num = 0;
            for (Map.Entry<String, String> entry : this.getFields().entrySet()) {
                this.out().print("  " + DataTableJson.quote(DataTableColumn.calculateName(entry.getKey())) + ": " + DataTableJson.quote(entry.getValue()));
                if (num++ != this.getFields().size() - 1) {
                    this.out().println(",");
                    continue;
                }
                this.out().println();
            }
        }
        this.out().println("}");
    }
}

