/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.DataTableCell;
import io.bdeploy.common.cli.data.DataTableColumn;
import io.bdeploy.common.cli.data.DataTableRowBuilder;
import io.bdeploy.common.cli.data.ExitCode;
import io.bdeploy.common.util.StringHelper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public abstract class DataTableBase
implements DataTable {
    private final PrintStream output;
    private String caption;
    private ExitCode exitCode = ExitCode.OK;
    private final List<DataTableColumn> columns = new ArrayList<DataTableColumn>();
    private final List<List<DataTableCell>> rows = new ArrayList<List<DataTableCell>>();
    private final List<String> footers = new ArrayList<String>();

    protected DataTableBase(PrintStream output) {
        this.output = output;
    }

    protected PrintStream out() {
        return this.output;
    }

    protected String getCaption() {
        return this.caption;
    }

    protected List<List<DataTableCell>> getRows() {
        return this.rows;
    }

    protected List<String> getFooters() {
        return this.footers;
    }

    protected String ellipsis(String data, int limit) {
        if (data.length() <= limit) {
            return data;
        }
        if (limit <= 3) {
            return data.substring(0, limit);
        }
        return data.substring(0, limit - 3) + "...";
    }

    protected String expand(String data, int width) {
        String limited = this.ellipsis(data, width);
        if (limited.length() < width) {
            return limited + StringHelper.repeat(" ", width - limited.length());
        }
        return limited;
    }

    @Override
    public DataTable setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public DataTable setIndentHint(int hint) {
        return this;
    }

    @Override
    public DataTable setLineWrapHint(boolean wrap) {
        return this;
    }

    @Override
    public DataTable setWordBreakHint(boolean allowBreak) {
        return this;
    }

    @Override
    public DataTable setHideHeadersHint(boolean hide) {
        return this;
    }

    @Override
    public DataTable addHorizontalRuler() {
        return this;
    }

    @Override
    public DataTable column(String label, int preferredWidth) {
        this.columns.add(new DataTableColumn(label, preferredWidth));
        return this;
    }

    @Override
    public DataTable column(DataTableColumn column) {
        this.columns.add(column);
        return this;
    }

    @Override
    public List<DataTableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public DataTable row(List<DataTableCell> list) {
        if (list.stream().map(i -> i.span).reduce(0, Integer::sum).intValue() != this.columns.size()) {
            throw new IllegalStateException("Column count mismatch in data table");
        }
        this.rows.add(list);
        return this;
    }

    @Override
    public DataTableRowBuilder row() {
        return new DataTableRowBuilder(this);
    }

    @Override
    public DataTable addFooter(String footer) {
        this.footers.add(footer);
        return this;
    }

    @Override
    public DataTable setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @Override
    public ExitCode getExitCode() {
        return this.exitCode;
    }
}

