/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

public class DataTableColumn {
    private final String name;
    private final String label;
    private final int preferredWidth;
    private int width = -1;

    public DataTableColumn(String label, int preferredWidth) {
        this(DataTableColumn.calculateName(label), label, preferredWidth);
    }

    static String calculateName(String label) {
        StringBuilder ret = new StringBuilder(label.length());
        for (String word : label.split("[ _-]")) {
            if ((word = word.replaceAll("[^a-zA-Z0-9]", "")).isEmpty()) continue;
            ret.append(Character.toUpperCase(word.charAt(0)));
            ret.append(word.substring(1).toLowerCase());
        }
        return ret.toString();
    }

    public DataTableColumn(String name, String label, int preferredWidth) {
        this.name = name;
        this.label = label;
        this.preferredWidth = preferredWidth;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width == -1 ? Math.max(this.preferredWidth, this.label.length()) : this.width;
    }

    public void setMaxCellLength(int maxCellLength) {
        this.width = maxCellLength;
        this.width = Math.min(this.width, this.preferredWidth * 2);
        this.width = Math.max(this.width, this.preferredWidth / 2);
        this.width = Math.max(this.width, this.label.length());
    }
}

