/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataTableBase;
import io.bdeploy.common.cli.data.DataTableCell;
import io.bdeploy.common.util.StringHelper;
import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;

public class DataTableCsv
extends DataTableBase {
    DataTableCsv(PrintStream output) {
        super(output);
    }

    @Override
    public void render() {
        this.out().println(String.join((CharSequence)",", this.getColumns().stream().map(c -> DataTableCsv.quote(c.getLabel())).collect(Collectors.toList())));
        for (List<DataTableCell> row : this.getRows()) {
            for (int y = 0; y < row.size(); ++y) {
                this.out().print(DataTableCsv.quote(row.get((int)y).data));
                if (y != row.size() - 1) {
                    this.out().print(StringHelper.repeat(",", row.get((int)y).span));
                    continue;
                }
                this.out().println();
            }
        }
    }

    static String quote(String data) {
        return "\"" + data.replace("\"", "\"\"") + "\"";
    }
}

