/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataTableBase;
import io.bdeploy.common.cli.data.DataTableCell;
import io.bdeploy.common.cli.data.DataTableColumn;
import java.io.PrintStream;
import java.util.List;

public class DataTableJson
extends DataTableBase {
    DataTableJson(PrintStream output) {
        super(output);
    }

    @Override
    public void render() {
        this.out().println("[");
        for (int i = 0; i < this.getRows().size(); ++i) {
            List<DataTableCell> row = this.getRows().get(i);
            this.out().print("  { ");
            int colIndex = 0;
            for (int y = 0; y < row.size(); ++y) {
                DataTableColumn col = this.getColumns().get(colIndex);
                this.out().print(DataTableJson.quote(col.getName()) + ": " + DataTableJson.quote(row.get((int)y).data));
                if (y == row.size() - 1) {
                    if (i == this.getRows().size() - 1) {
                        this.out().println(" }");
                    } else {
                        this.out().println(" },");
                    }
                } else {
                    this.out().print(", ");
                }
                colIndex += row.get((int)y).span;
            }
        }
        this.out().println("]");
    }

    static String quote(String data) {
        return "\"" + data.replace("\"", "\\\"").replace("\n", "\\n").replace("\\", "\\\\") + "\"";
    }
}

