/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli.data;

import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.DataTableBase;
import io.bdeploy.common.cli.data.DataTableCell;
import io.bdeploy.common.cli.data.DataTableColumn;
import io.bdeploy.common.util.StringHelper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class DataTableText
extends DataTableBase {
    private static final char CELL_NONE = '\u2500';
    private static final char CELL_BOTTOM = '\u252c';
    private static final char CELL_TOP = '\u2534';
    private static final char CELL_BOTH = '\u253c';
    private static final char CELL_SEPARATOR = '\u2502';
    private static final char TOP_START = '\u250c';
    private static final char TOP_END = '\u2510';
    private static final char BOTTOM_END = '\u2518';
    private static final char BOTTOM_START = '\u2514';
    private static final char CONTENT_END = '\u2524';
    private static final char CONTENT_START = '\u251c';
    private int indent;
    private boolean hideHeaders;
    private boolean lineWrap;
    private boolean allowBreak;

    DataTableText(PrintStream output) {
        super(output);
    }

    @Override
    public DataTable setIndentHint(int hint) {
        this.indent = hint;
        return this;
    }

    @Override
    public DataTable setHideHeadersHint(boolean hide) {
        this.hideHeaders = hide;
        return this;
    }

    @Override
    public DataTable setLineWrapHint(boolean wrap) {
        this.lineWrap = wrap;
        return this;
    }

    @Override
    public DataTable setWordBreakHint(boolean allowBreak) {
        this.allowBreak = allowBreak;
        return this;
    }

    @Override
    public DataTable addHorizontalRuler() {
        this.row(Collections.singletonList(new HrCell(this.getColumns().size())));
        return this;
    }

    @Override
    public void render() {
        ArrayList<String> buffer = new ArrayList<String>();
        List<DataTableColumn> columns = this.getColumns();
        List<List<DataTableCell>> rows = this.getRows();
        this.adjustColumnsWidth();
        if (this.getCaption() != null) {
            buffer.add(this.hr(HrMode.TOP));
            buffer.add(StringHelper.repeat(" ", this.indent) + this.content(this.getCaption(), 0, columns.size()));
        }
        buffer.add(this.hr(this.getCaption() != null ? HrMode.CONTENT : HrMode.TOP));
        if (!this.hideHeaders) {
            StringBuilder header = new StringBuilder();
            header.append(StringHelper.repeat(" ", this.indent));
            for (int i = 0; i < columns.size(); ++i) {
                header.append(this.content(columns.get(i).getLabel(), i, 1));
            }
            buffer.add(header.toString());
            buffer.add(this.hr(HrMode.CONTENT));
        }
        for (List<DataTableCell> raw : rows) {
            if (raw.size() == 1 && raw.get(0) instanceof HrCell) {
                buffer.add(this.hr(HrMode.CONTENT));
                continue;
            }
            List<List<DataTableCell>> expanded = Collections.singletonList(raw);
            if (this.lineWrap) {
                expanded = this.wrapRow(raw);
            }
            for (List<DataTableCell> data : expanded) {
                StringBuilder row = new StringBuilder();
                row.append(StringHelper.repeat(" ", this.indent));
                int colIndex = 0;
                for (int i = 0; i < data.size(); ++i) {
                    row.append(this.content(data.get((int)i).data, colIndex, data.get((int)i).span));
                    colIndex += data.get((int)i).span;
                }
                buffer.add(row.toString());
            }
        }
        if (!this.getFooters().isEmpty()) {
            buffer.add(this.hr(HrMode.CONTENT));
        }
        for (String footer : this.getFooters()) {
            buffer.add(this.content(footer, 0, this.getColumns().size()));
        }
        buffer.add(this.hr(HrMode.BOTTOM));
        this.processBuffer(buffer);
    }

    private void adjustColumnsWidth() {
        List<DataTableColumn> columns = this.getColumns();
        List<List<DataTableCell>> rows = this.getRows();
        HashMap<Integer, Integer> colIdxToMaxCellLength = new HashMap<Integer, Integer>();
        if (rows.isEmpty()) {
            return;
        }
        for (List<DataTableCell> row : rows) {
            int colIdx = 0;
            for (DataTableCell cell : row) {
                for (int i = 0; i < cell.span; ++i) {
                    int cellLength = cell.data.length() / cell.span;
                    int currentMax = colIdxToMaxCellLength.getOrDefault(colIdx, -1);
                    colIdxToMaxCellLength.put(colIdx, Math.max(currentMax, cellLength));
                    ++colIdx;
                }
            }
        }
        for (int i = 0; i < columns.size(); ++i) {
            DataTableColumn column = columns.get(i);
            column.setMaxCellLength((Integer)colIdxToMaxCellLength.get(i));
        }
    }

    private List<List<DataTableCell>> wrapRow(List<DataTableCell> raw) {
        List<DataTableColumn> columns = this.getColumns();
        ArrayList<List<DataTableCell>> expandedRows = new ArrayList<List<DataTableCell>>();
        TreeMap<Integer, List> perColumn = new TreeMap<Integer, List>();
        int colIndex = 0;
        for (DataTableCell item : raw) {
            List<DataTableColumn> spanning = columns.subList(colIndex, colIndex + item.span);
            int width = spanning.stream().map(DataTableColumn::getWidth).reduce(0, Integer::sum) + 3 * (spanning.size() - 1);
            String remaining = item.data;
            while (remaining.length() > width || remaining.contains("\n")) {
                int index;
                int newLine = remaining.indexOf(10);
                int n = index = newLine == -1 ? width : newLine;
                if (!this.allowBreak && newLine == -1) {
                    while (index-- > 0 && !Character.isWhitespace(remaining.charAt(index))) {
                    }
                    if (index <= 0) {
                        index = width;
                    }
                }
                perColumn.computeIfAbsent(colIndex, k -> new ArrayList()).add(new DataTableCell(remaining.substring(0, index), item.span));
                remaining = remaining.substring(index).trim();
            }
            perColumn.computeIfAbsent(colIndex, k -> new ArrayList()).add(new DataTableCell(remaining, item.span));
            colIndex += item.span;
        }
        Integer rowCount = perColumn.values().stream().map(List::size).reduce(0, Integer::max);
        for (int r = 0; r < rowCount; ++r) {
            expandedRows.add(new ArrayList());
        }
        perColumn.forEach((idx, items) -> {
            while (items.size() < rowCount) {
                items.add(new DataTableCell("", ((DataTableCell)items.get((int)0)).span));
            }
        });
        perColumn.forEach((idx, items) -> {
            for (int i = 0; i < rowCount; ++i) {
                ((List)expandedRows.get(i)).add((DataTableCell)items.get(i));
            }
        });
        return expandedRows;
    }

    private void processBuffer(List<String> buffer) {
        for (int i = 0; i < buffer.size(); ++i) {
            String line = buffer.get(i);
            String prev = StringHelper.repeat(" ", line.length());
            String next = StringHelper.repeat(" ", line.length());
            if (i > 0) {
                prev = buffer.get(i - 1);
            }
            if (i < buffer.size() - 1) {
                next = buffer.get(i + 1);
            }
            StringBuilder finalLine = new StringBuilder(line);
            int index = 0;
            int from = 0;
            while ((index = line.indexOf(9532, from)) != -1) {
                char prevChar = prev.charAt(index);
                char nextChar = next.charAt(index);
                if (prevChar == '\u2502' && nextChar != '\u2502') {
                    finalLine.setCharAt(index, '\u2534');
                } else if (prevChar != '\u2502' && nextChar == '\u2502') {
                    finalLine.setCharAt(index, '\u252c');
                } else if (prevChar != '\u2502' && nextChar != '\u2502') {
                    finalLine.setCharAt(index, '\u2500');
                }
                from = index + 1;
            }
            this.out().println(finalLine.toString());
        }
    }

    private String content(String text, int colIndex, int span) {
        text = text.replace("\t", "    ");
        StringBuilder builder = new StringBuilder();
        List<DataTableColumn> columns = this.getColumns();
        List<DataTableColumn> spanning = columns.subList(colIndex, colIndex + span);
        int width = spanning.stream().map(DataTableColumn::getWidth).reduce(0, Integer::sum) + 3 * (spanning.size() - 1);
        if (colIndex == 0) {
            builder.append('\u2502').append(' ');
        }
        builder.append(this.expand(text, width));
        if (colIndex + span == columns.size()) {
            builder.append(' ').append('\u2502');
        } else {
            builder.append(' ').append('\u2502').append(' ');
        }
        return builder.toString();
    }

    private String hr(HrMode mode) {
        StringBuilder builder = new StringBuilder();
        List<DataTableColumn> columns = this.getColumns();
        builder.append(StringHelper.repeat(" ", this.indent)).append(mode.start).append('\u2500');
        for (int i = 0; i < columns.size(); ++i) {
            DataTableColumn column = columns.get(i);
            builder.append(StringHelper.repeat(Character.toString('\u2500'), column.getWidth()));
            if (i != columns.size() - 1) {
                builder.append('\u2500').append('\u253c').append('\u2500');
                continue;
            }
            builder.append('\u2500').append(mode.stop);
        }
        return builder.toString();
    }

    private static class HrCell
    extends DataTableCell {
        public HrCell(int span) {
            super("-", span);
        }
    }

    private static enum HrMode {
        TOP('\u250c', '\u2510'),
        CONTENT('\u251c', '\u2524'),
        BOTTOM('\u2514', '\u2518');

        char start;
        char stop;

        private HrMode(char start, char stop) {
            this.start = start;
            this.stop = stop;
        }
    }
}

