/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import io.bdeploy.common.security.ScopedPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ApiAccessToken {
    public static final String SYSTEM_USER = "BDeploy System";
    String it;
    List<ScopedPermission> c = new ArrayList<ScopedPermission>();
    long ia;
    long vu;
    boolean wt;
    public static final ScopedPermission ADMIN_PERMISSION = new ScopedPermission(ScopedPermission.Permission.ADMIN);

    public String getIssuedTo() {
        return this.it;
    }

    public boolean isValid() {
        return this.vu > System.currentTimeMillis();
    }

    public boolean isWeak() {
        return this.wt;
    }

    public boolean isSystem() {
        return SYSTEM_USER.equals(this.it);
    }

    public Collection<ScopedPermission> getPermissions() {
        return Collections.unmodifiableCollection(this.c);
    }

    public static final class Builder {
        ApiAccessToken token = new ApiAccessToken();

        public Builder() {
            this.token.ia = System.currentTimeMillis();
            this.token.vu = this.token.ia + TimeUnit.DAYS.toMillis(17800L);
        }

        public Builder setIssuedTo(String name) {
            this.token.it = name;
            return this;
        }

        public Builder forSystem() {
            this.token.it = ApiAccessToken.SYSTEM_USER;
            return this;
        }

        public Builder setWeak(boolean weak) {
            this.token.wt = weak;
            return this;
        }

        public Builder addPermission(ScopedPermission permission) {
            if (!permission.isGlobal()) {
                throw new IllegalArgumentException("Only global permissions are allowed in access tokens");
            }
            this.token.c.add(permission);
            return this;
        }

        public Builder addPermission(Collection<ScopedPermission> permissions) {
            permissions.forEach(this::addPermission);
            return this;
        }

        public ApiAccessToken build() {
            return this.token;
        }
    }
}

