/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import io.bdeploy.common.security.KeyStoreProvider;
import io.bdeploy.common.security.SecurityHelper;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;

public class InMemoryKeyStore
implements KeyStoreProvider {
    private final char[] pp;
    private KeyStore store;
    private final SecurityHelper helper = SecurityHelper.getInstance();
    private final String authPack;

    public InMemoryKeyStore(String authPack) {
        this(authPack, Long.toString(System.currentTimeMillis()).toCharArray());
    }

    private InMemoryKeyStore(String authPack, char[] pp) {
        this.authPack = authPack;
        this.pp = Arrays.copyOf(pp, pp.length);
    }

    String getAuthPack() {
        return this.authPack;
    }

    @Override
    public KeyStore getStore() {
        if (this.store != null) {
            return this.store;
        }
        try {
            this.store = this.helper.loadPublicKeyStore((InputStream)null, this.pp);
            this.helper.importSignaturePack(this.authPack, this.store, this.pp);
            return this.store;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Cannot prepare KeyStore", e);
        }
    }

    @Override
    public char[] getPass() {
        return Arrays.copyOf(this.pp, this.pp.length);
    }
}

