/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import jakarta.ws.rs.ProcessingException;
import java.lang.reflect.InvocationTargetException;

public class ExceptionHelper {
    private ExceptionHelper() {
    }

    public static String mapExceptionCausesToReason(Throwable exception) {
        if (exception == null) {
            return "<unknown>";
        }
        StringBuilder reason = new StringBuilder();
        Throwable current = exception;
        String last = null;
        do {
            boolean ignore;
            String message = current.getMessage();
            boolean bl = ignore = ExceptionHelper.isIgnorableExceptionType(current) || message == null || message.equals(last);
            if (!ignore) {
                reason.append(message);
            }
            last = message;
            if (current instanceof InvocationTargetException) {
                current = ((InvocationTargetException)current).getTargetException();
            } else {
                if (current == current.getCause()) break;
                current = current.getCause();
            }
            if (current == null || ignore) continue;
            reason.append("; ");
        } while (current != null);
        return reason.toString();
    }

    private static boolean isIgnorableExceptionType(Throwable current) {
        return current instanceof ProcessingException;
    }
}

