/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import java.io.IOException;
import java.io.InputStream;

public class FixedLengthStream
extends InputStream {
    private final InputStream in;
    private long remaining;

    public FixedLengthStream(InputStream in, long totalSize) {
        this.in = in;
        this.remaining = totalSize;
    }

    @Override
    public int read() throws IOException {
        byte[] single = new byte[1];
        int num = this.read(single, 0, 1);
        return num == -1 ? -1 : single[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        long bytesToRead = Math.min((long)len, this.remaining);
        int numRead = this.in.read(b, off, (int)bytesToRead);
        if (numRead == -1) {
            throw new IOException("Unexpected end of stream. Expecting '" + this.remaining + "' bytes.");
        }
        this.remaining -= (long)numRead;
        return numRead;
    }
}

