/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;

public class FormatHelper {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat("#,##0.#");
    private static final DecimalFormat TRANSFER_FORMAT = new DecimalFormat("#0.0");
    private static final String[] SIZE_UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());

    private FormatHelper() {
    }

    public static String formatDuration(long timeInMillis) {
        return new SimpleDateFormat("mm 'min' ss 'sec' SSS 'ms'").format(new Date(timeInMillis));
    }

    public static String formatRemainingTime(long duration) {
        if (duration == 0L) {
            return "0 seconds";
        }
        long allSeconds = duration / 1000L;
        long seconds = allSeconds % 60L;
        long allMinutes = allSeconds / 60L;
        long minutes = allMinutes % 60L;
        long hours = allMinutes / 60L;
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours);
            builder.append(hours == 1L ? " hour" : " hours");
            return builder.toString();
        }
        if (minutes > 0L) {
            builder.append(minutes);
            builder.append(minutes == 1L ? " min" : " mins");
            return builder.toString();
        }
        builder.append(seconds);
        builder.append(seconds == 1L ? " sec" : " secs");
        return builder.toString();
    }

    public static String formatTransferRate(long bytes, long timeInMs) {
        if (bytes <= 0L || timeInMs < 1000L) {
            return "N/A";
        }
        double bps = (double)(bytes * 8L) / ((double)timeInMs / 1000.0);
        double kBs = bps / 8000.0;
        if (kBs > 1000.0) {
            return TRANSFER_FORMAT.format(kBs / 1000.0) + " MB/s";
        }
        return TRANSFER_FORMAT.format(kBs) + " KB/s";
    }

    public static String format(Date date) {
        return FORMATTER.format(date.toInstant());
    }

    public static String format(TemporalAccessor temporal) {
        return FORMATTER.format(temporal);
    }

    public static String format(long timestamp) {
        return FORMATTER.format(Instant.ofEpochMilli(timestamp));
    }

    public static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0 B";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return SIZE_FORMAT.format((double)size / Math.pow(1024.0, digitGroups)) + " " + SIZE_UNITS[digitGroups];
    }
}

