/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonHelper {
    private static final Logger log = LoggerFactory.getLogger(JacksonHelper.class);
    private static final LongAdder globalMapperCount = new LongAdder();
    private static final ObjectMapper DEF_JSON_MAPPER = JacksonHelper.createObjectMapper(MapperType.JSON);
    private static final ObjectMapper DEF_YAML_MAPPER = JacksonHelper.createObjectMapper(MapperType.YAML);

    private JacksonHelper() {
    }

    private static ObjectMapper createObjectMapper(JsonFactory factory) {
        ObjectMapper result = new ObjectMapper(factory);
        DefaultIndenter i = new DefaultIndenter("  ", "\n");
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        pp.indentArraysWith(i);
        pp.indentObjectsWith(i);
        result.setDefaultPrettyPrinter(pp);
        result.enable(SerializationFeature.INDENT_OUTPUT);
        result.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        result.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        result.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        result.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        result.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        result.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        result.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        result.registerModule(new Jdk8Module());
        result.registerModule(new JavaTimeModule());
        globalMapperCount.increment();
        if (log.isDebugEnabled()) {
            log.debug("Globally created ObjectMappers: {}", (Object)globalMapperCount.sum());
        }
        return result;
    }

    public static ObjectMapper createObjectMapper(MapperType type) {
        if (type == MapperType.JSON) {
            return JacksonHelper.createObjectMapper((JsonFactory)null);
        }
        return JacksonHelper.createObjectMapper(new YAMLFactory()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static ObjectMapper getDefaultJsonObjectMapper() {
        return DEF_JSON_MAPPER;
    }

    public static ObjectMapper getDefaultYamlObjectMapper() {
        return DEF_YAML_MAPPER;
    }

    public static enum MapperType {
        JSON,
        YAML;

    }
}

