/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import io.bdeploy.common.util.UuidHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.stream.Stream;

public class PathHelper {
    private static final ContentInfoUtil CIU = PathHelper.loadCIU();

    private static ContentInfoUtil loadCIU() {
        ContentInfoUtil contentInfoUtil;
        InputStreamReader rdr = new InputStreamReader(PathHelper.class.getClassLoader().getResourceAsStream("bdeploy-magic"), StandardCharsets.UTF_8);
        try {
            contentInfoUtil = new ContentInfoUtil(rdr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    rdr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("ERROR: Cannot load magic resource", e);
            }
        }
        rdr.close();
        return contentInfoUtil;
    }

    private PathHelper() {
    }

    public static boolean isDirEmpty(Path path) {
        boolean bl;
        block9: {
            if (!PathHelper.exists(path)) {
                return true;
            }
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public static Path ofNullableStrig(String path) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }

    public static boolean isReadOnly(Path path) {
        try {
            PathHelper.mkdirs(path);
            Path testFile = path.resolve(UuidHelper.randomId());
            Files.newOutputStream(testFile, new OpenOption[0]).close();
            Files.delete(testFile);
            return false;
        }
        catch (Exception ioe) {
            return true;
        }
    }

    public static boolean isReadOnly(Path directory, Path existingFile) {
        boolean readOnlyDir;
        boolean canCreate = true;
        boolean canDelete = true;
        Path testFile = directory.resolve(UuidHelper.randomId());
        try {
            PathHelper.mkdirs(directory);
            Files.newOutputStream(testFile, new OpenOption[0]).close();
        }
        catch (Exception ioe) {
            canCreate = false;
        }
        if (canCreate) {
            try {
                Files.delete(testFile);
            }
            catch (Exception ioe) {
                canDelete = false;
            }
        }
        if (canCreate && !canDelete) {
            throw new IllegalStateException("Inconsistent file and folder permissions: Missing permission to delete files.");
        }
        boolean bl = readOnlyDir = !canCreate;
        if (PathHelper.exists(existingFile)) {
            boolean writable = PathHelper.isWritable(existingFile);
            if (readOnlyDir && writable) {
                throw new IllegalStateException("Inconsistent file and folder permissions: Missing permission to create files.");
            }
            if (!readOnlyDir && !writable) {
                throw new IllegalStateException("Inconsistent file and folder permissions. Missing permission to modify files.");
            }
        }
        return readOnlyDir;
    }

    public static boolean isWritable(Path path) {
        try {
            Files.newOutputStream(path, StandardOpenOption.WRITE).close();
            return true;
        }
        catch (Exception ioe) {
            return false;
        }
    }

    public static void mkdirs(Path p) {
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create " + p, e);
        }
    }

    public static boolean moveAndDelete(Path source, Path target) {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            return false;
        }
        PathHelper.deleteRecursive(target);
        return true;
    }

    public static void deleteRecursive(Path path) {
        if (!PathHelper.exists(path)) {
            return;
        }
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            walk.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot delete " + path, e);
        }
    }

    public static String separatorsToUnix(Path path) {
        return path.toString().replace("\\", "/");
    }

    public static String getExtension(String file) {
        int position = file.lastIndexOf(46);
        if (position == -1) {
            return "";
        }
        return file.substring(position + 1);
    }

    public static FileSystem openZip(Path zipFile) throws IOException {
        TreeMap<String, Object> env = new TreeMap<String, Object>();
        env.put("create", "true");
        env.put("useTempFile", Boolean.TRUE);
        return FileSystems.newFileSystem(URI.create("jar:" + zipFile.toUri()), env);
    }

    public static boolean isExecutable(ContentInfo hint) {
        if (hint == null) {
            return false;
        }
        if (hint.getMimeType() != null) {
            switch (hint.getMimeType()) {
                case "application/x-sharedlib": 
                case "application/x-executable": 
                case "application/x-dosexec": 
                case "application/x-mach-binary": 
                case "text/x-shellscript": 
                case "text/x-msdos-batch": {
                    return true;
                }
            }
        }
        if (hint.getName() != null) {
            switch (hint.getName()) {
                case "ELF": 
                case "32+": 
                case "Mach-O": {
                    return true;
                }
            }
        }
        return hint.getMessage() != null && hint.getMessage().toLowerCase().contains("script text executable");
    }

    public static ContentInfo getContentInfo(Path child, ContentInfo hint) throws IOException {
        if (hint == null) {
            try (InputStream is = Files.newInputStream(child, new OpenOption[0]);){
                hint = CIU.findMatch(is);
            }
            if (hint == null) {
                return null;
            }
        }
        return hint;
    }

    public static ContentInfoUtil getContentInfoUtil() {
        return CIU;
    }

    public static PosixFileAttributeView getPosixView(Path path) {
        try {
            return Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean exists(Path path) {
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return Files.exists(path, new LinkOption[0]);
        }
        return path.toFile().exists();
    }
}

