/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.FormatHelper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReportingInputStream
extends FilterInputStream {
    private static final String ACTIVITY_TEMPLATE = "%1$s: %2$10s - %3$8s of %4$-8s - %5$s";
    private final long start = System.currentTimeMillis();
    private final String activityName;
    private final ActivityReporter.Activity activity;
    private final long bytesTotal;
    private long lastUpdate = System.currentTimeMillis();
    private long bytesToReport = 0L;
    private long bytesRead;

    public ReportingInputStream(InputStream in, long bytesTotal, ActivityReporter.Activity activity, String activityName) {
        super(in);
        this.bytesTotal = bytesTotal;
        this.activity = activity;
        this.activityName = activityName;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result == -1) {
            return -1;
        }
        this.bytesRead += (long)result;
        this.bytesToReport += (long)result;
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.start;
        long bytesRemaining = this.bytesTotal - this.bytesRead;
        long timeSinceLastUpdate = now - this.lastUpdate;
        if (timeSinceLastUpdate >= 500L && elapsedTime >= 1000L) {
            if (bytesRemaining < 0L) {
                this.activity.activity(this.activityName);
            } else {
                this.notifyWorked(elapsedTime, bytesRemaining);
            }
            this.bytesToReport = 0L;
            this.lastUpdate = now;
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        this.activity.worked(1L);
        return result;
    }

    private void notifyWorked(long elapsedTime, long bytesRemaining) {
        long remainingTimeMs = elapsedTime * bytesRemaining / this.bytesRead;
        String transferRate = FormatHelper.formatTransferRate(this.bytesRead, elapsedTime);
        String fSizeRead = FormatHelper.formatFileSize(this.bytesRead);
        String fTotalSize = FormatHelper.formatFileSize(this.bytesTotal);
        String fRemaining = FormatHelper.formatRemainingTime(remainingTimeMs).trim() + " remaining";
        this.activity.activity(String.format(ACTIVITY_TEMPLATE, this.activityName, transferRate, fSizeRead, fTotalSize, fRemaining));
        this.activity.worked(this.bytesToReport);
    }
}

