/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

public class StringHelper {
    private StringHelper() {
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static boolean isAllLowerCase(String s2) {
        if (s2.trim().isEmpty()) {
            return true;
        }
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.isLowerCase(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeat(String string, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return string;
        }
        byte[] value = string.getBytes();
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        StringBuilder builder = new StringBuilder(string.length() * count);
        while (count-- > 0) {
            builder.append(string);
        }
        return builder.toString();
    }
}

