/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class TaskExecutor {
    private final ActivityReporter reporter;
    private final List<Runnable> tasks = new ArrayList<Runnable>();

    public TaskExecutor(ActivityReporter reporter) {
        this.reporter = reporter;
    }

    public void add(Runnable task) {
        this.tasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String taskName) {
        ExecutorService service = Executors.newCachedThreadPool(new NamedDaemonThreadFactory(() -> "Task-" + taskName));
        try (ActivityReporter.Activity activity = this.reporter.start(taskName, this.tasks.size());){
            ArrayList futures = new ArrayList();
            for (Runnable task : this.tasks) {
                futures.add(service.submit(new ActivityRunnable(activity, task)));
            }
            RuntimeException failure = null;
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    if (failure != null) continue;
                    failure = new RuntimeException("Failed to execute task");
                    failure.addSuppressed(ie);
                }
                catch (Exception ex) {
                    if (failure != null) continue;
                    failure = new RuntimeException("Failed to execute task");
                    failure.addSuppressed(ex);
                }
            }
            if (failure != null) {
                throw failure;
            }
        }
        finally {
            service.shutdown();
        }
    }

    private class ActivityRunnable
    implements Runnable {
        private final ActivityReporter.Activity activity;
        private final Runnable task;

        public ActivityRunnable(ActivityReporter.Activity activity, Runnable task) {
            this.activity = activity;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
            this.activity.worked(1L);
        }
    }
}

