/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.util.ShouldResolve;
import io.bdeploy.common.util.StreamHelper;
import io.bdeploy.common.util.VariableResolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateHelper {
    private static final Logger log = LoggerFactory.getLogger(TemplateHelper.class);
    private static final String PATTERN_START = "{{";
    private static final String PATTERN_END = "}}";
    private static final Pattern PATTERN = Pattern.compile(Pattern.quote("{{") + "(.*?)" + Pattern.quote("}}"));

    private TemplateHelper() {
    }

    public static List<String> process(List<String> values, VariableResolver valueResolver) {
        return TemplateHelper.process(values, valueResolver, v -> true);
    }

    public static List<String> process(List<String> values, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        return values.stream().map(v -> TemplateHelper.process(v, valueResolver, shouldResolve)).collect(Collectors.toList());
    }

    public static String process(String value, VariableResolver valueResolver) {
        return TemplateHelper.process(value, valueResolver, v -> true);
    }

    public static String process(String value, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        if (value == null || !value.contains(PATTERN_START)) {
            return value;
        }
        return TemplateHelper.doProcess(value, valueResolver, shouldResolve);
    }

    private static String doProcess(String value, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        StringBuilder builder = new StringBuilder();
        int currentStart = 0;
        Matcher m3 = PATTERN.matcher(value);
        while (m3.find()) {
            String nextMatch = m3.group(1);
            Object resolved = nextMatch;
            if (shouldResolve != null && ((Boolean)shouldResolve.apply(nextMatch)).booleanValue()) {
                resolved = (String)valueResolver.apply(nextMatch);
                if (resolved == null) {
                    throw new IllegalArgumentException("Cannot find replacement for variable " + nextMatch + " while processing " + value);
                }
                resolved = TemplateHelper.doProcess((String)resolved, valueResolver, shouldResolve);
            } else {
                resolved = PATTERN_START + (String)resolved + PATTERN_END;
            }
            builder.append(value.substring(currentStart, m3.start()));
            builder.append((String)resolved);
            currentStart = m3.end();
        }
        builder.append(value.substring(currentStart, value.length()));
        return builder.toString();
    }

    public static String updateReferences(String value, UnaryOperator<String> processor) {
        StringBuilder builder = new StringBuilder();
        int currentStart = 0;
        Matcher m3 = PATTERN.matcher(value);
        while (m3.find()) {
            String nextMatch = m3.group(1);
            Object resolved = nextMatch;
            resolved = PATTERN_START + (String)processor.apply((String)resolved) + PATTERN_END;
            builder.append(value.substring(currentStart, m3.start()));
            builder.append((String)resolved);
            currentStart = m3.end();
        }
        builder.append(value.substring(currentStart, value.length()));
        return builder.toString();
    }

    public static void processFileTemplates(Path path, VariableResolver resolver) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> allPaths = Files.walk(path, new FileVisitOption[0]);){
            allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> TemplateHelper.processFileTemplate(p, resolver));
        }
        catch (IOException e) {
            log.error("Cannot walk configuration file tree", e);
        }
    }

    private static void processFileTemplate(Path file, VariableResolver resolver) {
        block12: {
            try (InputStream check = Files.newInputStream(file, new OpenOption[0]);){
                if (!StreamHelper.isTextFile(check)) {
                    return;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot check if file is a text file: " + file, e);
            }
            try {
                String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                String processed = TemplateHelper.process(content, resolver);
                Files.write(file, processed.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);
            }
            catch (Exception e) {
                log.warn("Cannot process configuration file: {}: {}", (Object)file, (Object)e.toString());
                if (!log.isDebugEnabled()) break block12;
                log.debug("Error details", e);
            }
        }
    }
}

