/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLish {
    private static final Pattern URL_ISH = Pattern.compile("(\\S+:\\/\\/)?((.+(?=:\\d))(:(\\d+))|((.+(?=\\/))|(.+)))?(\\/.*)?");
    public String scheme;
    public String hostname;
    public String port;
    public String pathAndQuery;

    public URLish(String url) {
        Matcher matcher = URL_ISH.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Not a valid URLish: " + url);
        }
        this.scheme = matcher.group(1);
        this.hostname = matcher.group(3) != null ? matcher.group(3) : matcher.group(6);
        this.port = matcher.group(5);
        this.pathAndQuery = matcher.group(9);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
        }
        builder.append(this.hostname);
        if (this.port != null) {
            builder.append(':');
            builder.append(this.port);
        }
        if (this.pathAndQuery != null) {
            builder.append(this.pathAndQuery);
        }
        return builder.toString();
    }
}

