/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionHelper {
    private static final String VERSION_PROP = "version";
    private static final Pattern V_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)([-\\.].*)*");
    public static final Version UNDEFINED = VersionHelper.parse("0.0.0");
    private static final Version version;
    private static final Properties properties;

    private VersionHelper() {
    }

    public static Version getVersion() {
        return version;
    }

    public static String getVersionAsString() {
        if (VersionHelper.isRunningUndefined()) {
            return "undefined";
        }
        return version.toString();
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return copy;
    }

    private static Properties readProperties() {
        Properties properties;
        block8: {
            InputStream is = VersionHelper.class.getResourceAsStream("/version.properties");
            try {
                Properties p = new Properties();
                p.load(is);
                properties = p;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    return new Properties();
                }
            }
            is.close();
        }
        return properties;
    }

    public static int compare(String a, String b) {
        return VersionHelper.compare(VersionHelper.parse(a), VersionHelper.parse(b));
    }

    public static int compare(Version a, Version b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static boolean equals(Version a, Version b) {
        return VersionHelper.compare(a, b) == 0;
    }

    public static Version parse(String v) {
        Version version = VersionHelper.tryParse(v);
        if (version == null) {
            throw new IllegalArgumentException("Given version does not match expected pattern");
        }
        return version;
    }

    public static Version tryParse(String v) {
        Matcher matcher = V_PATTERN.matcher(v);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static boolean isRunningUndefined() {
        return VersionHelper.isUndefined(VersionHelper.getVersion());
    }

    public static boolean isUndefined(Version version) {
        return VersionHelper.equals(version, UNDEFINED);
    }

    static {
        properties = VersionHelper.readProperties();
        if (!properties.containsKey(VERSION_PROP)) {
            properties.put(VERSION_PROP, System.getProperty("bdeploy.version.override", "0.0.0"));
        }
        version = VersionHelper.parse(properties.getProperty(VERSION_PROP));
    }
}

