/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipHelper {
    private static final int DEFAULT_NONEXEC_MODE = 420;
    private static final int DEFAULT_EXEC_MODE = 493;

    private ZipHelper() {
    }

    public static boolean isZipUri(URI uri) {
        return uri.getScheme().equals("jar") || uri.getScheme().equals("file") && uri.toString().toLowerCase().endsWith(".zip");
    }

    public static void zip(Path zipFile, Path source) {
        try (ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(zipFile.toFile());){
            ZipHelper.internalZip(source, zaos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create " + zipFile, e);
        }
    }

    public static void zip(OutputStream output, Path source) {
        try (ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(output);){
            ZipHelper.internalZip(source, zaos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot ZIP to stream", e);
        }
    }

    private static void internalZip(final Path source, final ZipArchiveOutputStream zaos) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!dir.equals(source)) {
                    String entryName = PathHelper.separatorsToUnix(source.relativize(dir));
                    zaos.putArchiveEntry(zaos.createArchiveEntry(dir.toFile(), entryName));
                    zaos.closeArchiveEntry();
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                ZipArchiveEntry zae = new ZipArchiveEntry(file.toFile(), source.relativize(file).toString());
                if (PathHelper.isExecutable(PathHelper.getContentInfo(file, null))) {
                    zae.setUnixMode(493);
                } else {
                    zae.setUnixMode(420);
                }
                zaos.putArchiveEntry(zae);
                Files.copy(file, zaos);
                zaos.closeArchiveEntry();
                return super.visitFile(file, attrs);
            }
        });
        zaos.finish();
    }

    public static void unzip(Path zipFile, Path target) {
        PathHelper.mkdirs(target);
        try (ZipFile zf = new ZipFile(zipFile.toFile());){
            Enumeration<ZipArchiveEntry> entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = entries.nextElement();
                Path path = target.resolve(entry.getName());
                if (!path.startsWith(target)) {
                    throw new IllegalStateException("The given zip contains absolute paths: " + zipFile);
                }
                if (entry.isDirectory()) {
                    PathHelper.mkdirs(path);
                    continue;
                }
                try (InputStream is = zf.getInputStream(entry);){
                    Files.copy(is, path, new CopyOption[0]);
                }
                ZipHelper.updatePermissions(path, entry.getUnixMode());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot unzip " + zipFile, e);
        }
    }

    private static void updatePermissions(Path file, int unixMode) throws IOException {
        Set<PosixFilePermission> permissions;
        if (ZipHelper.isPosixFileStore(file) && !(permissions = ZipHelper.getPosixPermissionsAsSet(unixMode)).isEmpty()) {
            Files.setPosixFilePermissions(file, permissions);
        }
    }

    private static boolean isPosixFileStore(Path path) {
        return PathHelper.getPosixView(path) != null;
    }

    private static Set<PosixFilePermission> getPosixPermissionsAsSet(int mode) {
        HashSet<PosixFilePermission> permissionSet = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) == 256) {
            permissionSet.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) == 128) {
            permissionSet.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) == 64) {
            permissionSet.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) == 32) {
            permissionSet.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) == 16) {
            permissionSet.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) == 8) {
            permissionSet.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) == 4) {
            permissionSet.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) == 2) {
            permissionSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) == 1) {
            permissionSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissionSet;
    }
}

