/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.audit.AuditRecord;
import io.bdeploy.common.audit.Auditor;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;

@Provider
public class JerseyAuditingFilter
implements ContainerResponseFilter {
    @Inject
    Auditor auditor;

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Response.StatusType status = responseContext.getStatusInfo();
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL && requestContext.getMethod().equals("GET")) {
            return;
        }
        this.auditor.audit(AuditRecord.Builder.fromRequest(requestContext).setSeverity(responseContext.getStatus() > 400 ? AuditRecord.Severity.WARNING : AuditRecord.Severity.NORMAL).setMessage(status.getStatusCode() + ": " + status.getReasonPhrase()).build());
    }
}

