/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.security.ApiAccessToken;
import io.bdeploy.common.security.SecurityHelper;
import io.bdeploy.jersey.JerseySecurityContext;
import io.bdeploy.jersey.errorpages.JerseyCustomErrorPages;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.annotation.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class JerseyAuthenticationProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String BDEPLOY_ALT_AUTH_HEADER = "X-BDeploy-Authorization";
    private static final String THREAD_ORIG_NAME = "THREAD_ORIG_NAME";
    private static final Logger log = LoggerFactory.getLogger(JerseyAuthenticationProvider.class);
    public static final String AUTHENTICATION_SCHEME = "Bearer";
    private static final String REALM = "BDeploy";
    private static final String NO_AUTH = "unsecured";
    private static final String WEAK_AUTH = "weak";
    private final KeyStore store;
    private final UserValidator userValidator;

    public JerseyAuthenticationProvider(KeyStore store, UserValidator userValidator) {
        this.store = store;
        this.userValidator = userValidator;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        Object authorizationHeader;
        String path = requestContext.getUriInfo().getPath();
        requestContext.setProperty(THREAD_ORIG_NAME, Thread.currentThread().getName());
        Thread.currentThread().setName(path);
        if (requestContext.getProperty(NO_AUTH) != null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Authenticating {}", (Object)path);
        }
        if ((authorizationHeader = requestContext.getHeaderString(BDEPLOY_ALT_AUTH_HEADER)) == null) {
            authorizationHeader = requestContext.getHeaderString("Authorization");
        }
        if (authorizationHeader == null && requestContext.getCookies().containsKey("st")) {
            authorizationHeader = "Bearer " + requestContext.getCookies().get("st").getValue();
        }
        if (!this.isTokenBasedAuthentication((String)authorizationHeader)) {
            this.abortWithUnauthorized(requestContext);
            return;
        }
        String token = ((String)authorizationHeader).substring(AUTHENTICATION_SCHEME.length()).trim();
        try {
            ApiAccessToken api = JerseyAuthenticationProvider.validateToken(token, this.store);
            if (api.isWeak() && requestContext.getProperty(WEAK_AUTH) == null) {
                this.abortWithUnauthorized(requestContext);
            }
            if (!api.isSystem() && this.userValidator != null && !this.userValidator.isValid(api.getIssuedTo())) {
                this.abortWithUnauthorized(requestContext);
            }
            requestContext.setSecurityContext(new JerseySecurityContext(api, requestContext.getHeaderString("X-On-Behalf-Of")));
        }
        catch (Exception e) {
            log.error("Exception while parsing authorization: {}", (Object)e.toString());
            this.abortWithUnauthorized(requestContext);
        }
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String name = (String)requestContext.getProperty(THREAD_ORIG_NAME);
        if (name != null) {
            Thread.currentThread().setName(name);
        }
    }

    private boolean isTokenBasedAuthentication(String authorizationHeader) {
        return authorizationHeader != null && authorizationHeader.toLowerCase().startsWith(AUTHENTICATION_SCHEME.toLowerCase() + " ");
    }

    private void abortWithUnauthorized(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).entity(JerseyCustomErrorPages.getErrorHtml(Response.Status.UNAUTHORIZED.getStatusCode(), "Not Authorized.")).header("WWW-Authenticate", "Bearer realm=\"BDeploy\"").build());
    }

    public static ApiAccessToken validateToken(String tokenValue, KeyStore ks) {
        try {
            ApiAccessToken token = SecurityHelper.getInstance().getVerifiedPayload(tokenValue, ApiAccessToken.class, ks);
            if (token != null && token.isValid()) {
                return token;
            }
            throw new IllegalStateException("Access token is null or no longer valid");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot verify access token.", e);
        }
    }

    @FunctionalInterface
    public static interface UserValidator {
        public boolean isValid(String var1);
    }

    @WeakTokenAllowed
    @Provider
    @Priority(value=998)
    public static class JerseyAuthenticationWeakenerProvider
    implements ContainerRequestFilter {
        @Override
        public void filter(ContainerRequestContext requestContext) throws IOException {
            requestContext.setProperty(JerseyAuthenticationProvider.WEAK_AUTH, JerseyAuthenticationProvider.WEAK_AUTH);
        }
    }

    @Unsecured
    @Provider
    @Priority(value=999)
    public static class JerseyAuthenticationUnprovider
    implements ContainerRequestFilter {
        @Override
        public void filter(ContainerRequestContext requestContext) throws IOException {
            requestContext.setProperty(JerseyAuthenticationProvider.NO_AUTH, JerseyAuthenticationProvider.NO_AUTH);
        }
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface WeakTokenAllowed {
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Unsecured {
    }
}

