/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import com.fasterxml.jackson.databind.Module;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.security.SecurityHelper;
import io.bdeploy.jersey.JerseyGZipFilter;
import io.bdeploy.jersey.JerseyObjectMapper;
import io.bdeploy.jersey.JerseyPathReader;
import io.bdeploy.jersey.JerseyPathWriter;
import io.bdeploy.jersey.activity.JerseyRemoteActivityScopeClientFilter;
import io.bdeploy.jersey.ws.change.client.ObjectChangeClientListener;
import io.bdeploy.jersey.ws.change.client.ObjectChangeClientWebSocket;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeDto;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyClientFactory {
    private static final Logger log;
    private static ActivityReporter defaultReporter;
    private SSLContext sslContext;
    private String bearer;
    private final RemoteService svc;
    private ActivityReporter reporter = defaultReporter;
    private final Set<Module> additionalModules = new HashSet<Module>();
    private JerseyObjectMapper mapperFeature;
    private WebTarget cachedTarget;
    private static final ThreadLocal<String> proxyUuid;
    private static final Cache<RemoteService, JerseyClientFactory> factoryCache;

    private JerseyClientFactory(RemoteService svc) {
        this.svc = svc;
        try {
            SecurityHelper sec = SecurityHelper.getInstance();
            this.bearer = sec.getSignedToken(svc.getKeyStore().getStore(), svc.getKeyStore().getPass());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(svc.getKeyStore().getStore());
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, tmf.getTrustManagers(), null);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot initialize security", e);
        }
    }

    public static JerseyClientFactory get(RemoteService svc) {
        try {
            return factoryCache.get(svc, () -> new JerseyClientFactory(svc));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot create/get client factory", e);
        }
    }

    public static void invalidateCached(RemoteService srv) {
        factoryCache.invalidate(srv);
    }

    public synchronized void register(Module o) {
        if (this.additionalModules.contains(o)) {
            return;
        }
        this.cachedTarget = null;
        this.additionalModules.add(o);
        this.mapperFeature = null;
    }

    public void setReporter(ActivityReporter reporter) {
        this.reporter = reporter;
    }

    public static void setDefaultReporter(ActivityReporter activityReporter) {
        defaultReporter = activityReporter;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    public <T> T getProxyClient(Class<T> clazz, Object ... additionalRegistrations) {
        Path path = clazz.getAnnotation(Path.class);
        if (path == null) {
            log.error("Resource '{}' does not have a @Path annotation.Seems to be a sub-resource that needs to be queried via a parent resource.", (Object)clazz);
        }
        return WebResourceFactory.newResource(clazz, this.getBaseTarget(additionalRegistrations));
    }

    public synchronized WebTarget getBaseTarget(Object ... additionalRegistrations) {
        if (additionalRegistrations.length == 0 && this.cachedTarget != null) {
            return this.cachedTarget;
        }
        ClientBuilder builder = ClientBuilder.newBuilder();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        builder.sslContext(this.sslContext);
        builder.hostnameVerifier((h2, s2) -> true);
        if (this.mapperFeature == null) {
            this.mapperFeature = new JerseyObjectMapper(this.additionalModules);
        }
        builder.register(this.mapperFeature);
        builder.register(GZipEncoder.class);
        builder.register(JerseyGZipFilter.class);
        builder.register(JacksonFeature.class);
        builder.register(MultiPartFeature.class);
        builder.register(new ClientBearerFilter(this.bearer));
        builder.register(JerseyPathReader.class);
        builder.register(JerseyPathWriter.class);
        builder.register(new JerseyClientReporterResolver());
        builder.register(new JerseyRemoteActivityScopeClientFilter(proxyUuid::get));
        for (Object reg : additionalRegistrations) {
            if (reg instanceof Class) {
                builder.register((Class)reg);
                continue;
            }
            builder.register(reg);
        }
        WebTarget target = builder.build().target(this.svc.getUri());
        if (additionalRegistrations.length == 0) {
            this.cachedTarget = target;
        }
        return target;
    }

    public static void setProxyUuid(String uuid) {
        if (uuid == null) {
            proxyUuid.remove();
        } else {
            proxyUuid.set(uuid);
        }
    }

    public AsyncHttpClient getWebSocketClient() {
        return new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build());
    }

    public ObjectChangeClientWebSocket getObjectChangeWebSocket(Consumer<ObjectChangeDto> onChanges) {
        AsyncHttpClient client = this.getWebSocketClient();
        ListenableFuture<WebSocket> ws = client.prepareGet(this.svc.getWebSocketUri("/object-changes").toString()).execute(new WebSocketUpgradeHandler.Builder().addWebSocketListener(new ObjectChangeClientListener(SecurityHelper.getInstance().getTokenFromPack(this.svc.getAuthPack()), onChanges)).build());
        try {
            return new ObjectChangeClientWebSocket(client, (WebSocket)ws.get());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Cannot open WebSocket (interrupted)", ie);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot open WebSocket", e);
        }
    }

    static {
        HttpsURLConnection.getDefaultSSLSocketFactory();
        log = LoggerFactory.getLogger(JerseyClientFactory.class);
        defaultReporter = new ActivityReporter.Null();
        proxyUuid = new ThreadLocal();
        factoryCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Provider
    private static class ClientBearerFilter
    implements ClientRequestFilter {
        private final String bearerToken;

        public ClientBearerFilter(String bearerToken) {
            this.bearerToken = bearerToken;
        }

        @Override
        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add("Authorization", "Bearer " + this.bearerToken);
        }
    }

    @Provider
    private final class JerseyClientReporterResolver
    implements ContextResolver<ActivityReporter> {
        private JerseyClientReporterResolver() {
        }

        @Override
        public ActivityReporter getContext(Class<?> type) {
            return JerseyClientFactory.this.reporter;
        }
    }
}

