/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.spi.ContentEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JerseyGZipFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JerseyGZipFilter.class);
    private static final String GZIP_ENCODING = "gzip";
    @Inject
    private InjectionManager injectionManager;
    private volatile List<Object> supportedEncodings = null;

    @Override
    public void filter(ClientRequestContext request) throws IOException {
        if (this.getSupportedEncodings().isEmpty()) {
            return;
        }
        request.getHeaders().addAll("Accept-Encoding", this.getSupportedEncodings());
        if (!this.getSupportedEncodings().contains(GZIP_ENCODING)) {
            log.warn("GZIP encoding not supported, supported encodings: {}", (Object)this.getSupportedEncodings());
        } else if (!request.hasEntity() || request.getHeaderString("Content-Type").contains("multipart") || request.getHeaders().getFirst("Content-Encoding") == null) {
            // empty if block
        }
    }

    List<Object> getSupportedEncodings() {
        if (this.supportedEncodings == null) {
            TreeSet<String> se = new TreeSet<String>();
            List encoders = this.injectionManager.getAllInstances((Type)((Object)ContentEncoder.class));
            for (ContentEncoder encoder : encoders) {
                se.addAll(encoder.getSupportedEncodings());
            }
            this.supportedEncodings = new ArrayList<Object>(se);
        }
        return this.supportedEncodings;
    }
}

