/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdeploy.common.util.JacksonHelper;
import jakarta.inject.Inject;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;

@Provider
public class JerseyObjectMapper
implements ContextResolver<ObjectMapper> {
    @Inject
    Iterable<Module> additionalModules;
    private final ObjectMapper mapper;

    public JerseyObjectMapper() {
        this(Collections.emptyList());
    }

    public JerseyObjectMapper(Iterable<Module> additional) {
        this.additionalModules = additional;
        this.mapper = this.createMapper();
    }

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    private ObjectMapper createMapper() {
        ObjectMapper result = JacksonHelper.createObjectMapper(JacksonHelper.MapperType.JSON);
        for (Module m3 : this.additionalModules) {
            result.registerModule(m3);
        }
        return result;
    }
}

