/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.jersey.JerseyStreamingHelper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@Provider
@Consumes(value={"application/octet-stream"})
public class JerseyPathReader
implements MessageBodyReader<Path> {
    static final String PATH_SIZE_HDR = "X-File-Size";
    @Context
    private Providers providers;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class.isAssignableFrom(type);
    }

    @Override
    public Path readFrom(Class<Path> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String cl = httpHeaders.getFirst(PATH_SIZE_HDR);
        long length = -1L;
        try {
            length = Long.parseLong(cl);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Path tmpFile = Files.createTempFile("dl-", ".bin", new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
            JerseyStreamingHelper.streamWithProgress(this.providers.getContextResolver(ActivityReporter.class, MediaType.WILDCARD_TYPE).getContext(ActivityReporter.class), JerseyStreamingHelper.StreamDirection.READ, entityStream, out, length);
        }
        return tmpFile;
    }
}

