/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.jersey.JerseyStreamingHelper;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

@Provider
@Produces(value={"application/octet-stream"})
public class JerseyPathWriter
implements MessageBodyWriter<Path> {
    @Context
    private ResourceInfo info;
    @Context
    private Providers providers;

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(Path t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        OpenOption[] openOptionArray;
        Method m3;
        long size = Files.size(t);
        boolean delete = false;
        if (this.info != null && (m3 = this.info.getResourceMethod()) != null && m3.getAnnotation(DeleteAfterWrite.class) != null) {
            delete = true;
        }
        httpHeaders.addFirst("X-File-Size", size);
        if (delete) {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.DELETE_ON_CLOSE;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] delOpt = openOptionArray;
        try (InputStream in = Files.newInputStream(t, delOpt);){
            JerseyStreamingHelper.streamWithProgress(this.providers.getContextResolver(ActivityReporter.class, MediaType.WILDCARD_TYPE).getContext(ActivityReporter.class), JerseyStreamingHelper.StreamDirection.WRITE, in, entityStream, size);
        }
        if (delete) {
            Files.deleteIfExists(t);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DeleteAfterWrite {
    }
}

