/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Map;
import java.util.TreeMap;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class JerseyRequestContext {
    private static final Logger log = LoggerFactory.getLogger(JerseyRequestContext.class);
    @Inject
    private Provider<ContainerRequestContext> reqCtx;
    private final ThreadLocal<Map<String, Object>> fallback = ThreadLocal.withInitial(() -> new TreeMap());

    public Object getProperty(String name) {
        try {
            return this.reqCtx.get().getProperty(name);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get property {}", (Object)name, (Object)e);
            }
            return this.fallback.get().get(name);
        }
    }

    public void setProperty(String name, Object object) {
        try {
            this.reqCtx.get().setProperty(name, object);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to set property {}", (Object)name, (Object)e);
            }
            this.fallback.get().put(name, object);
        }
    }

    public void removeProperty(String name) {
        try {
            this.reqCtx.get().removeProperty(name);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to remove property {}", (Object)name, (Object)e);
            }
            this.fallback.get().remove(name);
        }
    }

    public void clear() {
        this.fallback.remove();
    }
}

