/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.security.ApiAccessToken;
import io.bdeploy.common.security.ScopedPermission;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;

public class JerseySecurityContext
implements SecurityContext {
    private static final ScopedPermission WEAK_READ = new ScopedPermission(ScopedPermission.Permission.READ);
    private final ApiAccessToken token;
    private final String onBehalfOf;

    public JerseySecurityContext(ApiAccessToken token, String onBehalfOf) {
        this.token = token;
        this.onBehalfOf = onBehalfOf;
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.onBehalfOf != null) {
            return () -> "[" + this.onBehalfOf + "]";
        }
        return this.token::getIssuedTo;
    }

    @Override
    public boolean isUserInRole(String role) {
        return false;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public String getAuthenticationScheme() {
        return "Bearer";
    }

    public boolean isAuthorized(ScopedPermission scopedPermission) {
        Collection<ScopedPermission> perms = this.token.getPermissions();
        if (this.token.isWeak()) {
            perms = Collections.singleton(WEAK_READ);
        }
        for (ScopedPermission sc : perms) {
            if (!sc.satisfies(scopedPermission)) continue;
            return true;
        }
        return false;
    }
}

