/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.audit.Auditor;
import io.bdeploy.common.audit.Slf4jAuditor;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import io.bdeploy.common.util.Threads;
import io.bdeploy.common.util.VersionHelper;
import io.bdeploy.jersey.JerseyAuditingFilter;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import io.bdeploy.jersey.JerseyExceptionMapper;
import io.bdeploy.jersey.JerseyMetricsFilter;
import io.bdeploy.jersey.JerseyObjectMapper;
import io.bdeploy.jersey.JerseyPathReader;
import io.bdeploy.jersey.JerseyPathWriter;
import io.bdeploy.jersey.JerseyRequestContext;
import io.bdeploy.jersey.JerseyScopeService;
import io.bdeploy.jersey.JerseyWriteLockFilter;
import io.bdeploy.jersey.JerseyWriteLockService;
import io.bdeploy.jersey.RegistrationTarget;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import io.bdeploy.jersey.activity.JerseyRemoteActivityResourceImpl;
import io.bdeploy.jersey.activity.JerseyRemoteActivityScopeServerFilter;
import io.bdeploy.jersey.fs.FileSystemSpaceService;
import io.bdeploy.jersey.monitoring.JerseyServerMonitor;
import io.bdeploy.jersey.monitoring.JerseyServerMonitoringResourceImpl;
import io.bdeploy.jersey.monitoring.JerseyServerMonitoringSamplerService;
import io.bdeploy.jersey.resources.JerseyMetricsResourceImpl;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JerseyServer
implements AutoCloseable,
RegistrationTarget {
    private static final int CL_BUFFER_SIZE = 512;
    private static final Logger log = LoggerFactory.getLogger(JerseyServer.class);
    public static final String START_TIME = "StartTime";
    public static final String BROADCAST_EXECUTOR = "BcExecutor";
    public static final String FILE_SYSTEM_MIN_SPACE = "FileSystemMinSpace";
    private final int port;
    private final ResourceConfig rc = new ResourceConfig();
    private final KeyStore store;
    private final char[] passphrase;
    private final Instant startTime = Instant.now();
    private final Collection<AutoCloseable> closeableResources = new ArrayList<AutoCloseable>();
    private final ActivityReporter.Delegating reporterDelegate = new ActivityReporter.Delegating();
    private final CompletableFuture<RegistrationTarget> startup = new CompletableFuture();
    private final AtomicLong broadcasterId = new AtomicLong(0L);
    private final ScheduledExecutorService broadcastScheduler = Executors.newScheduledThreadPool(1, new NamedDaemonThreadFactory(() -> "Scheduled Broadcast " + this.broadcasterId.incrementAndGet()));
    private final Map<HttpHandlerRegistration, HttpHandler> preRegistrations = new HashMap<HttpHandlerRegistration, HttpHandler>();
    private HttpServer server;
    private Auditor auditor = new Slf4jAuditor();
    private final JerseyServerMonitor monitor = new JerseyServerMonitor();
    private final JerseyServerMonitoringSamplerService serverMonitoring = new JerseyServerMonitoringSamplerService(this.monitor);
    private final Map<String, WebSocketApplication> wsApplications = new TreeMap<String, WebSocketApplication>();
    private JerseyAuthenticationProvider.UserValidator userValidator;
    private GrizzlyHttpContainer container;

    public JerseyServer(int port, KeyStore store, char[] passphrase) {
        this.port = port;
        this.store = store;
        this.passphrase = (char[])passphrase.clone();
    }

    @Override
    public KeyStore getKeyStore() {
        return this.store;
    }

    public CompletableFuture<RegistrationTarget> afterStartup() {
        return this.startup;
    }

    public ActivityReporter getRemoteActivityReporter() {
        return this.reporterDelegate;
    }

    public void setAuditor(Auditor auditor) {
        this.auditor = auditor;
        this.registerResource(auditor);
    }

    public void setUserValidator(JerseyAuthenticationProvider.UserValidator validator) {
        this.userValidator = validator;
    }

    @Override
    public void registerResource(AutoCloseable closeable) {
        this.closeableResources.add(closeable);
    }

    @Override
    public void register(Object provider) {
        if (provider instanceof Class) {
            Priority prio = ((Class)provider).getAnnotation(Priority.class);
            if (prio != null) {
                this.rc.register((Class)provider, prio.value());
            } else {
                this.rc.register((Class)provider);
            }
        } else {
            this.rc.register(provider);
        }
    }

    @Override
    public void addHandler(HttpHandler handler, HttpHandlerRegistration registration) {
        if (this.server == null) {
            this.preRegistrations.put(registration, handler);
        } else {
            this.server.getServerConfiguration().addHttpHandler(handler, registration);
        }
    }

    @Override
    public void removeHandler(HttpHandler handler) {
        if (this.server == null) {
            Set<HttpHandlerRegistration> r = this.preRegistrations.entrySet().stream().filter(e -> ((HttpHandler)e.getValue()).equals(handler)).map(Map.Entry::getKey).collect(Collectors.toSet());
            r.forEach(this.preRegistrations::remove);
        } else {
            this.server.getServerConfiguration().removeHttpHandler(handler);
        }
    }

    @Override
    public void registerWebsocketApplication(String urlMapping, WebSocketApplication wsa) {
        this.wsApplications.put(urlMapping, wsa);
    }

    public static void updateLogging() {
        if (SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.uninstall();
        }
        Level target = Level.WARNING;
        if (log.isInfoEnabled()) {
            target = Level.INFO;
        }
        if (log.isDebugEnabled()) {
            target = Level.FINE;
        }
        if (log.isTraceEnabled()) {
            target = Level.FINER;
        }
        java.util.logging.Logger.getLogger("").setLevel(target);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public void start() {
        try {
            URI jerseyUri = UriBuilder.fromUri("https://0.0.0.0/api").port(this.port).build(new Object[0]);
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(this.store, this.passphrase);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmfactory.getKeyManagers(), null, null);
            SSLEngineConfigurator sslEngine = new SSLEngineConfigurator(ctx, false, false, false);
            sslEngine.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.3"});
            this.registerDefaultResources(this.rc);
            this.server = GrizzlyHttpServerFactory.createHttpServer(jerseyUri, this.rc, true, sslEngine, false);
            this.container = ContainerFactory.createContainer(GrizzlyHttpContainer.class, this.rc);
            this.server = GrizzlyHttpServerFactory.createHttpServer(jerseyUri, this.container, true, sslEngine, false);
            for (Map.Entry<HttpHandlerRegistration, HttpHandler> regs : this.preRegistrations.entrySet()) {
                this.server.getServerConfiguration().addHttpHandler(regs.getValue(), regs.getKey());
            }
            this.monitor.setServer(this.server);
            WebSocketAddOn wsao = new WebSocketAddOn();
            for (NetworkListener listener : this.server.getListeners()) {
                int coresCount = 8;
                ThreadPoolConfig cfg = ThreadPoolConfig.defaultConfig().setPoolName("BDeploy-Transport-Worker").setCorePoolSize(8).setMaxPoolSize(Integer.MAX_VALUE).setMemoryManager(listener.getTransport().getMemoryManager());
                listener.getTransport().setWorkerThreadPoolConfig(cfg);
                CompressionConfig cc = listener.getCompressionConfig();
                cc.setCompressionMode(CompressionConfig.CompressionMode.ON);
                cc.setCompressionMinSize(512);
                cc.setDecompressionEnabled(true);
                listener.registerAddOn(wsao);
            }
            this.wsApplications.forEach((path, app) -> WebSocketEngine.getEngine().register("/ws", (String)path, (WebSocketApplication)app));
            this.server.getHttpHandler().setAllowEncodedSlash(true);
            this.server.start();
            log.info("Started Version {}", (Object)VersionHelper.getVersion());
            this.startup.complete(this);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Cannot start server", e);
        }
    }

    public void registerDefaultResources(ResourceConfig config) {
        config.register(new ServerObjectBinder());
        config.register((Class)JerseyObjectMapper.class);
        config.register((Class)JacksonFeature.class);
        config.register((Class)MultiPartFeature.class);
        config.register((Object)new JerseyAuthenticationProvider(this.store, this.userValidator), 1000);
        config.register((Class)JerseyAuthenticationProvider.JerseyAuthenticationUnprovider.class, 999);
        config.register((Class)JerseyAuthenticationProvider.JerseyAuthenticationWeakenerProvider.class, 998);
        config.register((Class)JerseyPathReader.class);
        config.register((Class)JerseyPathWriter.class);
        config.register((Class)JerseyMetricsFilter.class);
        config.register((Class)JerseyMetricsResourceImpl.class);
        config.register((Class)JerseyAuditingFilter.class);
        config.register((Class)JerseyExceptionMapper.class);
        config.register((Class)JerseyRemoteActivityResourceImpl.class);
        config.register((Class)JerseyRemoteActivityScopeServerFilter.class);
        config.register((Class)JerseyServerMonitoringResourceImpl.class);
        config.register(new JerseyLazyReporterInitializer());
        config.register(new JerseyServerReporterContextResolver());
        config.register(new JerseyWriteLockFilter());
        config.property("jersey.config.server.contentLength.buffer", 512);
    }

    public boolean isRunning() {
        return this.server != null && this.server.isStarted();
    }

    @Override
    public void close() {
        for (AutoCloseable closeable : this.closeableResources) {
            try {
                log.info("Closing resource '{}'", (Object)closeable);
                closeable.close();
                if (!log.isDebugEnabled()) continue;
                log.debug("Resource '{}' closed", (Object)closeable);
            }
            catch (Exception ex) {
                log.error("Failed to close resource '{}'", (Object)closeable, (Object)ex);
            }
        }
        this.closeableResources.clear();
        if (this.server != null) {
            this.server.shutdownNow();
            this.server = null;
        }
    }

    public boolean join() {
        while (this.isRunning()) {
            if (Threads.sleep(1000L)) continue;
            return this.isRunning();
        }
        return this.isRunning();
    }

    private class ServerObjectBinder
    extends AbstractBinder {
        private ServerObjectBinder() {
        }

        @Override
        protected void configure() {
            this.bind(JerseyBroadcastingActivityReporter.class).in(Singleton.class).to(JerseyBroadcastingActivityReporter.class);
            this.bind(JerseyWriteLockService.class).in(Singleton.class).to(JerseyWriteLockService.class);
            this.bind(JerseyScopeService.class).in(Singleton.class).to(JerseyScopeService.class);
            this.bind(JerseyRequestContext.class).in(Singleton.class).to(JerseyRequestContext.class);
            this.bind(FileSystemSpaceService.class).in(Singleton.class).to(FileSystemSpaceService.class);
            this.bind(JerseyServer.this.startTime).named(JerseyServer.START_TIME).to(Instant.class);
            this.bind(JerseyServer.this.broadcastScheduler).named(JerseyServer.BROADCAST_EXECUTOR).to(ScheduledExecutorService.class);
            this.bind(JerseyServer.this.serverMonitoring).to(JerseyServerMonitoringSamplerService.class);
            this.bindFactory(new JerseyAuditorBridgeFactory()).to(Auditor.class);
            this.bindFactory(JerseyRemoteActivityReporterBridgeFactory.class).to(ActivityReporter.class);
        }
    }

    private class JerseyLazyReporterInitializer
    implements ContainerLifecycleListener {
        private JerseyLazyReporterInitializer() {
        }

        @Override
        public void onStartup(Container container) {
            JerseyServer.this.reporterDelegate.setDelegate(container.getApplicationHandler().getInjectionManager().getInstance(JerseyBroadcastingActivityReporter.class));
        }

        @Override
        public void onReload(Container container) {
        }

        @Override
        public void onShutdown(Container container) {
        }
    }

    @Provider
    private class JerseyServerReporterContextResolver
    implements ContextResolver<ActivityReporter> {
        private JerseyServerReporterContextResolver() {
        }

        @Override
        public ActivityReporter getContext(Class<?> type) {
            return JerseyServer.this.reporterDelegate;
        }
    }

    private static class JerseyRemoteActivityReporterBridgeFactory
    implements Factory<ActivityReporter> {
        @Inject
        private JerseyBroadcastingActivityReporter reporter;

        private JerseyRemoteActivityReporterBridgeFactory() {
        }

        @Override
        public ActivityReporter provide() {
            return this.reporter;
        }

        @Override
        public void dispose(ActivityReporter instance) {
        }
    }

    private class JerseyAuditorBridgeFactory
    implements Factory<Auditor> {
        private JerseyAuditorBridgeFactory() {
        }

        @Override
        public Auditor provide() {
            return JerseyServer.this.auditor;
        }

        @Override
        public void dispose(Auditor instance) {
        }
    }
}

